/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.concurrent;

import com.terracottatech.offheapstore.ReadWriteLockedOffHeapClockCache;
import com.terracottatech.offheapstore.concurrent.SegmentFactory;
import com.terracottatech.offheapstore.eviction.EvictionListener;
import com.terracottatech.offheapstore.eviction.EvictionListeningReadWriteLockedOffHeapClockCache;
import com.terracottatech.offheapstore.paging.PageSource;
import com.terracottatech.offheapstore.storage.StorageEngine;
import com.terracottatech.offheapstore.storage.StorageEngineFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadWriteLockedOffHeapClockCacheFactory<K, V>
implements SegmentFactory<K, V> {
    private static final int DEFAULT_TABLE_SIZE = 128;
    private final StorageEngineFactory<? super K, ? super V> storageEngineFactory;
    private final PageSource tableSource;
    private final int tableSize;
    private final EvictionListener<K, V> evictionListener;

    public ReadWriteLockedOffHeapClockCacheFactory(PageSource tableSource, StorageEngineFactory<? super K, ? super V> storageEngineFactory) {
        this(tableSource, storageEngineFactory, 128);
    }

    public ReadWriteLockedOffHeapClockCacheFactory(PageSource tableSource, StorageEngineFactory<? super K, ? super V> storageEngineFactory, EvictionListener<K, V> evictionListener) {
        this(tableSource, storageEngineFactory, evictionListener, 128);
    }

    public ReadWriteLockedOffHeapClockCacheFactory(PageSource tableSource, StorageEngineFactory<? super K, ? super V> storageEngineFactory, int tableSize) {
        this(tableSource, storageEngineFactory, null, tableSize);
    }

    public ReadWriteLockedOffHeapClockCacheFactory(PageSource tableSource, StorageEngineFactory<? super K, ? super V> storageEngineFactory, EvictionListener<K, V> evictionListener, int tableSize) {
        this.storageEngineFactory = storageEngineFactory;
        this.tableSource = tableSource;
        this.tableSize = tableSize;
        this.evictionListener = evictionListener;
    }

    @Override
    public ReadWriteLockedOffHeapClockCache<K, V> newInstance() {
        StorageEngine<K, V> storageEngine = this.storageEngineFactory.newInstance();
        try {
            if (this.evictionListener == null) {
                return new ReadWriteLockedOffHeapClockCache<K, V>(this.tableSource, storageEngine, this.tableSize);
            }
            return new EvictionListeningReadWriteLockedOffHeapClockCache<K, V>(this.evictionListener, this.tableSource, storageEngine, this.tableSize);
        }
        catch (RuntimeException e) {
            storageEngine.destroy();
            throw e;
        }
    }
}

