/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.concurrent;

import com.terracottatech.offheapstore.Segment;
import com.terracottatech.offheapstore.concurrent.AbstractConcurrentOffHeapMap;
import com.terracottatech.offheapstore.concurrent.SegmentFactory;
import com.terracottatech.offheapstore.exceptions.OversizeMappingException;
import java.util.concurrent.locks.Lock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConcurrentOffHeapCache<K, V>
extends AbstractConcurrentOffHeapMap<K, V> {
    public AbstractConcurrentOffHeapCache(SegmentFactory<K, V> segmentFactory, boolean latencyMonitoring) {
        super(segmentFactory, latencyMonitoring);
    }

    public AbstractConcurrentOffHeapCache(SegmentFactory<K, V> segmentFactory, int concurrency, boolean latencyMonitoring) {
        super(segmentFactory, concurrency, latencyMonitoring);
    }

    @Override
    public V put(K key, V value) {
        while (true) {
            try {
                return super.put(key, value);
            }
            catch (OversizeMappingException e) {
                if (this.handleOversizeMappingException(key)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        while (true) {
            try {
                return super.putIfAbsent(key, value);
            }
            catch (OversizeMappingException e) {
                if (this.handleOversizeMappingException(key)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        while (true) {
            try {
                return super.replace(key, oldValue, newValue);
            }
            catch (OversizeMappingException e) {
                if (this.handleOversizeMappingException(key)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public V replace(K key, V value) {
        while (true) {
            try {
                return super.replace(key, value);
            }
            catch (OversizeMappingException e) {
                if (this.handleOversizeMappingException(key)) continue;
                throw e;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleOversizeMappingException(K key) {
        boolean evicted = false;
        Segment target = this.segmentFor(key);
        for (Segment s : this.segments) {
            if (s == target) continue;
            Lock l = s.getWriteLock();
            l.lock();
            try {
                evicted |= s.shrink();
            }
            finally {
                l.unlock();
            }
        }
        return evicted;
    }
}

