/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore;

import com.terracottatech.offheapstore.FixedAbstractCollection;
import com.terracottatech.offheapstore.FixedAbstractSet;
import com.terracottatech.offheapstore.OffHeapHashMap;
import com.terracottatech.offheapstore.Segment;
import com.terracottatech.offheapstore.paging.PageSource;
import com.terracottatech.offheapstore.storage.StorageEngine;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLockedOffHeapHashMap<K, V>
extends OffHeapHashMap<K, V>
implements Segment<K, V> {
    private Set<Map.Entry<K, V>> entrySet;
    private Set<K> keySet;
    private Collection<V> values;

    public AbstractLockedOffHeapHashMap(PageSource source, StorageEngine<? super K, ? super V> storageEngine) {
        super(source, storageEngine);
    }

    public AbstractLockedOffHeapHashMap(PageSource source, boolean tableAllocationsSteal, StorageEngine<? super K, ? super V> storageEngine) {
        super(source, tableAllocationsSteal, storageEngine);
    }

    public AbstractLockedOffHeapHashMap(PageSource source, StorageEngine<? super K, ? super V> storageEngine, boolean bootstrap) {
        super(source, storageEngine, bootstrap);
    }

    public AbstractLockedOffHeapHashMap(PageSource source, StorageEngine<? super K, ? super V> storageEngine, int tableSize) {
        super(source, storageEngine, tableSize);
    }

    public AbstractLockedOffHeapHashMap(PageSource source, boolean tableAllocationsSteal, StorageEngine<? super K, ? super V> storageEngine, int tableSize) {
        super(source, tableAllocationsSteal, storageEngine, tableSize);
    }

    public AbstractLockedOffHeapHashMap(PageSource source, StorageEngine<? super K, ? super V> storageEngine, int tableSize, boolean bootstrap) {
        super(source, false, storageEngine, tableSize, bootstrap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Lock l = this.getReadLock();
        l.lock();
        try {
            int n = super.size();
            return n;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        Lock l = this.getReadLock();
        l.lock();
        try {
            boolean bl = super.containsKey(key);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        Lock l = this.getReadLock();
        l.lock();
        try {
            Object v = super.get(key);
            return v;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        Lock l = this.getWriteLock();
        l.lock();
        try {
            V v = super.put(key, value);
            return v;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        Lock l = this.getWriteLock();
        l.lock();
        try {
            Object v = super.remove(key);
            return v;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Lock l = this.getWriteLock();
        l.lock();
        try {
            super.clear();
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        Lock l = this.getWriteLock();
        l.lock();
        try {
            if (key == null || value == null) {
                throw new NullPointerException();
            }
            Object existing = super.get(key);
            if (existing == null) {
                super.put(key, value);
            }
            Object v = existing;
            return v;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        Lock l = this.getWriteLock();
        l.lock();
        try {
            if (key == null) {
                throw new NullPointerException();
            }
            if (value == null) {
                boolean bl = false;
                return bl;
            }
            Object existing = super.get(key);
            if (value.equals(existing)) {
                super.remove(key);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        Lock l = this.getWriteLock();
        l.lock();
        try {
            Object existing = super.get(key);
            if (oldValue.equals(existing)) {
                super.put(key, newValue);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        Lock l = this.getWriteLock();
        l.lock();
        try {
            if (value == null || key == null) {
                throw new NullPointerException();
            }
            Object existing = super.get(key);
            if (existing != null) {
                super.put(key, value);
            }
            Object v = existing;
            return v;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean removeMapping(Object o) {
        Lock l = this.getWriteLock();
        l.lock();
        try {
            boolean bl = super.removeMapping(o);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evict(int index, boolean shrink) {
        Lock l = this.getWriteLock();
        l.lock();
        try {
            super.evict(index, shrink);
        }
        finally {
            l.unlock();
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        LockedEntrySet es = this.entrySet;
        return es == null ? (this.entrySet = new LockedEntrySet()) : es;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new LockedKeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new FixedAbstractCollection<V>(){

                @Override
                public Iterator<V> iterator() {
                    return new Iterator<V>(){
                        private final Iterator<Map.Entry<K, V>> i;
                        {
                            this.i = AbstractLockedOffHeapHashMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public V next() {
                            return this.i.next().getValue();
                        }

                        @Override
                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return AbstractLockedOffHeapHashMap.this.size();
                }

                @Override
                public boolean isEmpty() {
                    return AbstractLockedOffHeapHashMap.this.isEmpty();
                }

                @Override
                public void clear() {
                    AbstractLockedOffHeapHashMap.this.clear();
                }

                @Override
                public boolean contains(Object v) {
                    return AbstractLockedOffHeapHashMap.this.containsValue(v);
                }
            };
        }
        return this.values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Lock l = this.getWriteLock();
        l.lock();
        try {
            super.destroy();
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shrink() {
        Lock l = this.getWriteLock();
        l.lock();
        try {
            boolean bl = this.storageEngine.shrink();
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LockedKeyIterator
    extends OffHeapHashMap.KeyIterator {
        LockedKeyIterator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K next() {
            Lock l = AbstractLockedOffHeapHashMap.this.getReadLock();
            l.lock();
            try {
                Object t = super.next();
                return t;
            }
            finally {
                l.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            Lock l = AbstractLockedOffHeapHashMap.this.getWriteLock();
            l.lock();
            try {
                super.remove();
            }
            finally {
                l.unlock();
            }
        }

        @Override
        protected void checkForConcurrentModification() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LockedKeySet
    extends FixedAbstractSet<K> {
        LockedKeySet() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<K> iterator() {
            Lock l = AbstractLockedOffHeapHashMap.this.getReadLock();
            l.lock();
            try {
                LockedKeyIterator lockedKeyIterator = new LockedKeyIterator();
                return lockedKeyIterator;
            }
            finally {
                l.unlock();
            }
        }

        @Override
        public boolean contains(Object o) {
            return AbstractLockedOffHeapHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractLockedOffHeapHashMap.this.remove(o) != null;
        }

        @Override
        public int size() {
            return AbstractLockedOffHeapHashMap.this.size();
        }

        @Override
        public void clear() {
            AbstractLockedOffHeapHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LockedEntryIterator
    extends OffHeapHashMap.EntryIterator {
        LockedEntryIterator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, V> next() {
            Lock l = AbstractLockedOffHeapHashMap.this.getReadLock();
            l.lock();
            try {
                Map.Entry entry = (Map.Entry)super.next();
                return entry;
            }
            finally {
                l.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            Lock l = AbstractLockedOffHeapHashMap.this.getWriteLock();
            l.lock();
            try {
                super.remove();
            }
            finally {
                l.unlock();
            }
        }

        @Override
        protected void checkForConcurrentModification() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LockedEntrySet
    extends FixedAbstractSet<Map.Entry<K, V>> {
        LockedEntrySet() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            Lock l = AbstractLockedOffHeapHashMap.this.getReadLock();
            l.lock();
            try {
                LockedEntryIterator lockedEntryIterator = new LockedEntryIterator();
                return lockedEntryIterator;
            }
            finally {
                l.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Lock l = AbstractLockedOffHeapHashMap.this.getReadLock();
            l.lock();
            try {
                Object value = AbstractLockedOffHeapHashMap.this.get(e.getKey());
                boolean bl = value != null && value.equals(e.getValue());
                return bl;
            }
            finally {
                l.unlock();
            }
        }

        @Override
        public boolean remove(Object o) {
            return AbstractLockedOffHeapHashMap.this.removeMapping(o);
        }

        @Override
        public int size() {
            return AbstractLockedOffHeapHashMap.this.size();
        }

        @Override
        public void clear() {
            AbstractLockedOffHeapHashMap.this.clear();
        }
    }
}

