/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.portability;

import com.terracottatech.offheapstore.storage.portability.Portability;
import com.terracottatech.offheapstore.storage.portability.SerializablePortability;
import com.terracottatech.offheapstore.util.ByteBufferInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.offheap.portability.AbstractEhcachePortability;
import net.sf.ehcache.util.TimeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhcacheElementPortability
extends AbstractEhcachePortability
implements Portability<Element> {
    private static final byte COMPACT_ELEMENT = 1;
    private static final byte EXTENDED_ELEMENT = 2;

    public EhcacheElementPortability() {
        super(new SerializablePortability());
    }

    protected EhcacheElementPortability(SerializablePortability delegate) {
        super(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer encode(Element element) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        try {
            try {
                if (element.usesCacheDefaultLifespan()) {
                    dout.writeByte(1);
                    dout.writeLong(element.getVersion());
                    dout.writeInt(TimeUtil.toSecs(element.getElementEvictionData().getCreationTime()));
                    dout.writeInt(TimeUtil.toSecs(element.getElementEvictionData().getLastAccessTime()));
                    dout.writeInt(TimeUtil.toSecs(element.getLastUpdateTime()));
                } else {
                    dout.writeByte(2);
                    dout.writeLong(element.getVersion());
                    dout.writeInt(element.getTimeToLive());
                    dout.writeInt(element.getTimeToIdle());
                    dout.writeInt(TimeUtil.toSecs(element.getElementEvictionData().getCreationTime()));
                    dout.writeInt(TimeUtil.toSecs(element.getElementEvictionData().getLastAccessTime()));
                    dout.writeInt(TimeUtil.toSecs(element.getLastUpdateTime()));
                }
                this.writeObjects(dout, element.getKey(), element.getValue());
            }
            finally {
                dout.close();
            }
        }
        catch (IOException e) {
            throw new CacheException("Failed while encoding element " + element, e);
        }
        return ByteBuffer.wrap(bout.toByteArray());
    }

    @Override
    public Element decode(ByteBuffer buffer) {
        try {
            DataInputStream din = new DataInputStream(new ByteBufferInputStream(buffer));
            byte type = din.readByte();
            switch (type) {
                case 1: {
                    long version = din.readLong();
                    long creation = TimeUtil.toMillis(din.readInt());
                    long access = TimeUtil.toMillis(din.readInt());
                    long update = TimeUtil.toMillis(din.readInt());
                    Serializable[] payload = this.readObjects(din, 2);
                    return new Element(payload[0], payload[1], version, creation, access, update, 0L);
                }
                case 2: {
                    long version = din.readLong();
                    int ttl = din.readInt();
                    int tti = din.readInt();
                    long creation = TimeUtil.toMillis(din.readInt());
                    long access = TimeUtil.toMillis(din.readInt());
                    long update = TimeUtil.toMillis(din.readInt());
                    Serializable[] payload = this.readObjects(din, 2);
                    return new Element(payload[0], payload[1], version, creation, access, 0L, false, ttl, tti, update);
                }
            }
            throw new CacheException("Unknown Element encoding " + type);
        }
        catch (ClassNotFoundException e) {
            throw new CacheException("Failed while decoding element " + buffer, e);
        }
        catch (IOException e) {
            throw new CacheException("Failed while decoding element " + buffer, e);
        }
    }

    @Override
    public boolean equals(Object object, ByteBuffer buffer) {
        return object.equals(this.decode(buffer));
    }
}

