/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.disk.persistent;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.TimeUnit;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Status;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.store.offheap.configuration.DerivedDiskConfiguration;
import net.sf.ehcache.store.offheap.disk.EhcachePersistentConcurrentOffHeapClockCache;
import net.sf.ehcache.store.offheap.disk.OffHeapDiskStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffHeapPersistentDiskStore
extends OffHeapDiskStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(OffHeapPersistentDiskStore.class);
    private final File indexFile;

    public static OffHeapPersistentDiskStore create(Ehcache cache, String diskStorePath) {
        if (diskStorePath == null) {
            throw new CacheException(cache.getName() + " Cache: Could not create disk store. " + "This CacheManager configuration does not allow creation of DiskStores. " + "If you wish to create DiskStores, please configure a diskStore path.");
        }
        File diskPath = new File(diskStorePath);
        if (diskPath.exists() && !diskPath.isDirectory()) {
            throw new CacheException("Store directory \"" + diskPath.getAbsolutePath() + "\" exists and is not a directory.");
        }
        if (!diskPath.exists() && !diskPath.mkdirs()) {
            throw new CacheException("Could not create cache directory \"" + diskPath.getAbsolutePath() + "\".");
        }
        File dataFile = new File(diskPath, cache.getName().replace('/', '_') + ".data");
        File indexFile = new File(diskPath, cache.getName().replace('/', '_') + ".index");
        try {
            if (diskPath.getAbsolutePath().contains("ehcache_auto_created")) {
                LOGGER.warn("Data in persistent disk stores is ignored for stores from automatically created directories (they start with ehcache_auto_created).\nRemove diskPersistent or resolve the conflicting disk paths in cache configuration.\nDeleting data file " + dataFile.getAbsolutePath());
                return OffHeapPersistentDiskStore.createNew(cache, dataFile, indexFile);
            }
            if (dataFile.isFile() && indexFile.isFile()) {
                return OffHeapPersistentDiskStore.recoverExisting(cache, dataFile, indexFile);
            }
            LOGGER.debug("Missing data and/or index file for {}.  Creating a new empty store.", (Object)cache.getName());
            return OffHeapPersistentDiskStore.createNew(cache, dataFile, indexFile);
        }
        catch (IOException e) {
            throw new CacheException("Failed to create disk store", e);
        }
    }

    private static OffHeapPersistentDiskStore createNew(Ehcache cache, File dataFile, File indexFile) throws IOException {
        CacheConfiguration config = cache.getCacheConfiguration();
        EhcachePersistentConcurrentOffHeapClockCache map = EhcachePersistentConcurrentOffHeapClockCache.create(dataFile, cache.getCacheEventNotificationService(), config, new DerivedDiskConfiguration(cache.getName(), config.getMaxMemoryOffHeapInBytes()));
        return new OffHeapPersistentDiskStore(dataFile, indexFile, map, cache.getCacheEventNotificationService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static OffHeapPersistentDiskStore recoverExisting(Ehcache cache, File dataFile, File indexFile) throws IOException {
        try {
            ObjectInputStream input = new ObjectInputStream(new FileInputStream(indexFile));
            try {
                long dataTimestampFromIndex = input.readLong();
                long dataTimestampFromFile = dataFile.lastModified();
                long delta = dataTimestampFromFile - dataTimestampFromIndex;
                if (delta < 0L) {
                    LOGGER.info("The index for data file {} is more recent than the data file itself by {}ms : this is harmless.", (Object)dataFile.getName(), (Object)(-delta));
                } else {
                    if (delta > TimeUnit.SECONDS.toMillis(1L)) {
                        LOGGER.warn("The index for data file {} is out of date by {}ms, probably due to an unclean shutdown. Creating a new empty store.", (Object)dataFile.getName(), (Object)delta);
                        OffHeapPersistentDiskStore offHeapPersistentDiskStore = OffHeapPersistentDiskStore.createNew(cache, dataFile, indexFile);
                        return offHeapPersistentDiskStore;
                    }
                    if (delta > 0L) {
                        LOGGER.info("The index for data file {} is out of date by {}ms, assuming this small delta is a result of the OS/filesystem.", (Object)dataFile.getName(), (Object)delta);
                    }
                }
                CacheConfiguration config = cache.getCacheConfiguration();
                EhcachePersistentConcurrentOffHeapClockCache map = EhcachePersistentConcurrentOffHeapClockCache.recover(input, dataFile, cache.getCacheEventNotificationService(), config, new DerivedDiskConfiguration(cache.getName(), config.getMaxMemoryOffHeapInBytes()));
                OffHeapPersistentDiskStore offHeapPersistentDiskStore = new OffHeapPersistentDiskStore(dataFile, indexFile, map, cache.getCacheEventNotificationService());
                return offHeapPersistentDiskStore;
            }
            finally {
                input.close();
            }
        }
        catch (IOException e) {
            LOGGER.debug("Index file was corrupt. Deleting data file " + dataFile.getAbsolutePath());
            return OffHeapPersistentDiskStore.createNew(cache, dataFile, indexFile);
        }
    }

    public OffHeapPersistentDiskStore(File dataFile, File indexFile, EhcachePersistentConcurrentOffHeapClockCache map, RegisteredEventListeners eventService) {
        super(dataFile, map, eventService);
        this.indexFile = indexFile;
    }

    public synchronized void dispose() {
        if (this.status.compareAndSet(Status.STATUS_ALIVE, Status.STATUS_SHUTDOWN)) {
            try {
                this.map.flush();
                this.persist();
                this.map.close();
            }
            catch (IOException e) {
                throw new CacheException("Failed to cleanly dispose the disk store", e);
            }
        }
    }

    public synchronized void flush() throws IOException {
        this.map.flush();
        this.persist();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void persist() throws IOException {
        ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream(this.indexFile));
        try {
            output.writeLong(System.currentTimeMillis());
            this.map.persist(output);
        }
        finally {
            output.close();
        }
    }
}

