/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.disk;

import com.terracottatech.offheapstore.Segment;
import com.terracottatech.offheapstore.disk.paging.MappedPageSource;
import com.terracottatech.offheapstore.disk.persistent.AbstractPersistentConcurrentOffHeapMap;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.offheap.EhcacheConcurrentOffHeapClockCache;
import net.sf.ehcache.store.offheap.configuration.Configuration;
import net.sf.ehcache.store.offheap.factories.EhcachePersistentSegmentFactory;
import net.sf.ehcache.store.offheap.factories.EhcachePersistentStorageEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhcachePersistentConcurrentOffHeapClockCache
extends AbstractPersistentConcurrentOffHeapMap<Serializable, Element> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EhcacheConcurrentOffHeapClockCache.class);
    private final EhcachePersistentStorageEngineFactory storageEngineFactory;
    private final long diskSpoolBufferSize;
    private final String cacheName;
    private List<ReentrantReadWriteLock> locks;
    private volatile long averageMappingSize = -1L;

    public static EhcachePersistentConcurrentOffHeapClockCache create(File dataFile, RegisteredEventListeners evictionListener, CacheConfiguration cacheConfig, Configuration config) throws IOException {
        LOGGER.info("Creating On Disk Area Using Config\n {}", (Object)config);
        MappedPageSource source = new MappedPageSource(dataFile);
        int accessStripes = Math.min(config.getConcurrency(), cacheConfig.getDiskAccessStripes());
        EhcachePersistentStorageEngineFactory storageEngineFactory = new EhcachePersistentStorageEngineFactory(source, config.getSegmentDataPageSize(), accessStripes);
        return new EhcachePersistentConcurrentOffHeapClockCache(evictionListener, cacheConfig, source, storageEngineFactory, config.getInitialSegmentTableSize(), config.getConcurrency());
    }

    public static EhcachePersistentConcurrentOffHeapClockCache recover(ObjectInput input, File dataFile, RegisteredEventListeners evictionListener, CacheConfiguration cacheConfig, Configuration config) throws IOException {
        MappedPageSource source = new MappedPageSource(dataFile, false);
        try {
            int accessStripes = Math.min(config.getConcurrency(), cacheConfig.getDiskAccessStripes());
            EhcachePersistentStorageEngineFactory storageEngineFactory = new EhcachePersistentStorageEngineFactory(source, config.getSegmentDataPageSize(), accessStripes, false);
            EhcachePersistentConcurrentOffHeapClockCache map = new EhcachePersistentConcurrentOffHeapClockCache(input, evictionListener, cacheConfig, source, storageEngineFactory, config.getInitialSegmentTableSize());
            map.bootstrap(input);
            return map;
        }
        catch (IOException e) {
            source.close();
            throw e;
        }
    }

    private EhcachePersistentConcurrentOffHeapClockCache(RegisteredEventListeners evictionListener, CacheConfiguration config, MappedPageSource source, EhcachePersistentStorageEngineFactory storageEngineFactory, int initialTableSize, int concurrency) {
        super(new EhcachePersistentSegmentFactory(evictionListener, source, storageEngineFactory, initialTableSize, config.getMaxElementsOnDisk(), true), concurrency, false);
        this.diskSpoolBufferSize = (long)config.getDiskSpoolBufferSizeMB() * 1024L * 1024L;
        this.storageEngineFactory = storageEngineFactory;
        this.cacheName = config.getName();
    }

    private EhcachePersistentConcurrentOffHeapClockCache(ObjectInput input, RegisteredEventListeners evictionListener, CacheConfiguration config, MappedPageSource source, EhcachePersistentStorageEngineFactory storageEngineFactory, int initialTableSize) throws IOException {
        super(new EhcachePersistentSegmentFactory(evictionListener, source, storageEngineFactory, initialTableSize, config.getMaxElementsOnDisk(), false), EhcachePersistentConcurrentOffHeapClockCache.readSegmentCount(input), false);
        this.diskSpoolBufferSize = (long)config.getDiskSpoolBufferSizeMB() * 1024L * 1024L;
        this.storageEngineFactory = storageEngineFactory;
        this.cacheName = config.getName();
    }

    public ReentrantReadWriteLock getLock(Object key) {
        return this.segmentFor(key).getLock();
    }

    public boolean bufferFull() {
        long estimatedQueueSize;
        boolean backedUp;
        if (this.averageMappingSize < 0L) {
            this.averageMappingSize = this.getAverageMappingSize();
        }
        boolean bl = backedUp = (estimatedQueueSize = this.storageEngineFactory.getTotalQueueSize() * this.averageMappingSize) > this.diskSpoolBufferSize;
        if (backedUp) {
            this.averageMappingSize = this.getAverageMappingSize();
            LOGGER.debug("A back up on disk store puts occurred. Consider increasing diskSpoolBufferSizeMB for cache " + this.cacheName);
        }
        return backedUp;
    }

    private long getAverageMappingSize() {
        long size = this.getSize();
        if (size == 0L) {
            return -1L;
        }
        return this.getOccupiedMemory() / size;
    }

    public List<ReentrantReadWriteLock> getOrderedLocks() {
        List<ReentrantReadWriteLock> l = this.locks;
        return l == null ? (this.locks = this.generateLockList()) : l;
    }

    private List<ReentrantReadWriteLock> generateLockList() {
        ArrayList<ReentrantReadWriteLock> l = new ArrayList<ReentrantReadWriteLock>(this.segments.length);
        for (Segment c : this.segments) {
            l.add(c.getLock());
        }
        return Collections.unmodifiableList(l);
    }

    public boolean remove(Object key, Element element, ElementValueComparator comparator) {
        EhcachePersistentSegmentFactory.EhcachePersistentSegment segment = (EhcachePersistentSegmentFactory.EhcachePersistentSegment)this.segmentFor(key);
        return segment.remove(key, element, comparator);
    }

    public boolean replace(Serializable key, Element oldValue, Element newValue, ElementValueComparator comparator) {
        EhcachePersistentSegmentFactory.EhcachePersistentSegment segment = (EhcachePersistentSegmentFactory.EhcachePersistentSegment)this.segmentFor(key);
        return segment.replace(key, oldValue, newValue, comparator);
    }
}

