/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.configuration;

import com.terracottatech.offheapstore.util.DebuggingUtils;
import net.sf.ehcache.store.offheap.configuration.Configuration;
import net.sf.ehcache.store.offheap.configuration.HeuristicConfiguration;

public class DerivedDiskConfiguration
implements Configuration {
    private static final long MINIMAL_MAX_DISK_STORE_SIZE = 0L;
    private static final int DISK_TO_OFFHEAP_SIZE_RATIO = 4;
    private static final int MINIMAL_DISK_STORE_SEGMENTS = 16;
    private static final int ASSUMED_KEY_VALUE_SIZE = Integer.getInteger("net.sf.ehcache.offheap.heuristicConfig.assumedKeyValueSize", 1024);
    private final String cacheName;
    private final Configuration offHeapConfig;

    public DerivedDiskConfiguration(String cacheName, Configuration config) {
        this.cacheName = cacheName;
        this.offHeapConfig = config;
    }

    public DerivedDiskConfiguration(String cacheName, long maxMemoryOffHeapInBytes) {
        this(cacheName, new HeuristicConfiguration(cacheName, maxMemoryOffHeapInBytes));
    }

    public long getMaximumSize() {
        throw new UnsupportedOperationException("Disk stores do not use this property");
    }

    public int getMinimumChunkSize() {
        throw new UnsupportedOperationException("Disk stores do not use this property");
    }

    public int getMaximumChunkSize() {
        throw new UnsupportedOperationException("Disk stores do not use this property");
    }

    public int getConcurrency() {
        long maxDiskStoreSize = Math.max(0L, 4L * this.offHeapConfig.getMaximumSize());
        int segments = (int)(maxDiskStoreSize / Integer.MAX_VALUE);
        return Math.max(16, Integer.highestOneBit(segments));
    }

    public int getInitialSegmentTableSize() {
        return (int)(this.offHeapConfig.getMaximumSize() / (long)this.getConcurrency() / (long)ASSUMED_KEY_VALUE_SIZE);
    }

    public int getSegmentDataPageSize() {
        return this.offHeapConfig.getSegmentDataPageSize() * (this.offHeapConfig.getConcurrency() / this.getConcurrency());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Derived Disk Configuration: " + this.cacheName + "\n");
        sb.append("Concurrency                : ").append(this.getConcurrency()).append("\n");
        sb.append("Initial Segment Table Size : ").append(DebuggingUtils.toBase2SuffixedString(this.getInitialSegmentTableSize())).append(" slots\n");
        sb.append("Segment Data Page Size  : ").append(DebuggingUtils.toBase2SuffixedString(this.getSegmentDataPageSize())).append("B\n");
        return sb.toString();
    }
}

