/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.compound.NullReadWriteCopyStrategy;
import net.sf.ehcache.store.offheap.FrontEndCacheTier;
import net.sf.ehcache.transaction.AbstractTransactionStore;
import net.sf.ehcache.transaction.SoftLock;
import net.sf.ehcache.writer.CacheWriterManager;

public class TransactionalBackedStore
extends AbstractTransactionStore {
    private final ConcurrentMap<Object, Element> softLocks = new ConcurrentHashMap<Object, Element>();
    private final FrontEndCacheTier frontEndCacheTier;

    public TransactionalBackedStore(FrontEndCacheTier frontEndCacheTier) {
        super(frontEndCacheTier, new NullReadWriteCopyStrategy());
        this.frontEndCacheTier = frontEndCacheTier;
    }

    private void writeLock() {
        this.frontEndCacheTier.writeLock();
    }

    private void writeLock(Object key) {
        this.frontEndCacheTier.writeLock(key);
    }

    private void writeUnlock() {
        this.frontEndCacheTier.writeUnlock();
    }

    private void writeUnlock(Object key) {
        this.frontEndCacheTier.writeUnlock(key);
    }

    private void readLock() {
        this.frontEndCacheTier.readLock();
    }

    private void readLock(Object key) {
        this.frontEndCacheTier.readLock(key);
    }

    private void readUnlock() {
        this.frontEndCacheTier.readUnlock();
    }

    private void readUnlock(Object key) {
        this.frontEndCacheTier.readUnlock(key);
    }

    private Element createSoftLockPlaceHolderElement(Element element) {
        return new Element(element.getObjectKey(), null, element.getVersion(), element.getCreationTime(), element.getLastAccessTime(), element.getHitCount(), element.usesCacheDefaultLifespan(), element.getTimeToLive(), element.getTimeToIdle(), element.getLastUpdateTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(Element element) throws CacheException {
        if (element == null) {
            return false;
        }
        Object key = element.getObjectKey();
        this.writeLock(key);
        try {
            Object value = element.getObjectValue();
            if (value instanceof SoftLock) {
                this.softLocks.put(key, element);
                boolean bl = this.frontEndCacheTier.put(this.createSoftLockPlaceHolderElement(element));
                return bl;
            }
            this.softLocks.remove(key);
            boolean bl = this.frontEndCacheTier.put(element);
            return bl;
        }
        finally {
            this.writeUnlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putWithWriter(Element element, CacheWriterManager writerManager) {
        if (element == null) {
            return false;
        }
        Object key = element.getObjectKey();
        this.writeLock(key);
        try {
            boolean result = this.put(element);
            if (writerManager != null) {
                writerManager.put(element);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.writeUnlock(key);
        }
    }

    public Element get(Object key) {
        if (key == null) {
            return null;
        }
        Element softLockedElement = (Element)this.softLocks.get(key);
        if (softLockedElement != null) {
            return softLockedElement;
        }
        return this.frontEndCacheTier.get(key);
    }

    public Element getQuiet(Object key) {
        if (key == null) {
            return null;
        }
        Element softLockedElement = (Element)this.softLocks.get(key);
        if (softLockedElement != null) {
            return softLockedElement;
        }
        return this.frontEndCacheTier.getQuiet(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element remove(Object key) {
        if (key == null) {
            return null;
        }
        this.writeLock(key);
        try {
            Element softLock = (Element)this.softLocks.remove(key);
            Element regular = this.frontEndCacheTier.remove(key);
            if (softLock == null) {
                Element element = regular;
                return element;
            }
            Element element = softLock;
            return element;
        }
        finally {
            this.writeUnlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element removeWithWriter(Object key, CacheWriterManager writerManager) throws CacheException {
        if (key == null) {
            return null;
        }
        this.writeLock(key);
        try {
            Element softLock = (Element)this.softLocks.remove(key);
            Element regular = this.frontEndCacheTier.removeWithWriter(key, writerManager);
            if (softLock == null) {
                Element element = regular;
                return element;
            }
            Element element = softLock;
            return element;
        }
        finally {
            this.writeUnlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() throws CacheException {
        this.writeLock();
        try {
            this.softLocks.clear();
            this.frontEndCacheTier.removeAll();
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element putIfAbsent(Element element) throws NullPointerException {
        if (element == null) {
            throw new NullPointerException("element cannot be null");
        }
        if (element.getObjectKey() == null) {
            throw new NullPointerException("element key cannot be null");
        }
        Object key = element.getObjectKey();
        this.writeLock(key);
        try {
            Element softLock;
            Element result;
            if (element.getObjectValue() instanceof SoftLock) {
                result = this.frontEndCacheTier.putIfAbsent(this.createSoftLockPlaceHolderElement(element));
                if (result == null) {
                    this.softLocks.put(key, element);
                }
            } else {
                result = this.frontEndCacheTier.putIfAbsent(element);
            }
            if (result != null && (softLock = (Element)this.softLocks.get(key)) != null) {
                Element element2 = softLock;
                return element2;
            }
            Element element3 = result;
            return element3;
        }
        finally {
            this.writeUnlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element removeElement(Element element, ElementValueComparator comparator) throws NullPointerException {
        if (element == null) {
            throw new NullPointerException("element cannot be null");
        }
        if (element.getObjectKey() == null) {
            throw new NullPointerException("element key cannot be null");
        }
        if (comparator == null) {
            throw new NullPointerException("comparator cannot be null");
        }
        Object key = element.getObjectKey();
        this.writeLock(key);
        try {
            Element softLockedElement = (Element)this.softLocks.get(key);
            if (!comparator.equals(element, softLockedElement != null ? softLockedElement : this.frontEndCacheTier.getQuiet(key))) {
                Element element2 = null;
                return element2;
            }
            Element result = this.frontEndCacheTier.remove(key);
            if (softLockedElement != null) {
                this.softLocks.remove(key);
                Element element3 = softLockedElement;
                return element3;
            }
            Element element4 = result;
            return element4;
        }
        finally {
            this.writeUnlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(Element old, Element element, ElementValueComparator comparator) throws NullPointerException, IllegalArgumentException {
        if (old == null) {
            throw new NullPointerException("old cannot be null");
        }
        if (old.getObjectKey() == null) {
            throw new NullPointerException("old key cannot be null");
        }
        if (element == null) {
            throw new NullPointerException("element cannot be null");
        }
        if (element.getObjectKey() == null) {
            throw new NullPointerException("element key cannot be null");
        }
        if (comparator == null) {
            throw new NullPointerException("comparator cannot be null");
        }
        if (!old.getKey().equals(element.getKey())) {
            throw new IllegalArgumentException("old and element keys are not equal");
        }
        Object key = element.getObjectKey();
        this.writeLock(key);
        try {
            Element softLockedElement = (Element)this.softLocks.get(key);
            if (!comparator.equals(old, softLockedElement != null ? softLockedElement : this.frontEndCacheTier.getQuiet(key))) {
                boolean bl = false;
                return bl;
            }
            if (element.getObjectValue() instanceof SoftLock) {
                this.frontEndCacheTier.put(this.createSoftLockPlaceHolderElement(element));
                this.softLocks.put(key, element);
            } else {
                this.frontEndCacheTier.put(element);
                if (softLockedElement != null) {
                    this.softLocks.remove(key);
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeUnlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element replace(Element element) throws NullPointerException {
        if (element == null) {
            throw new NullPointerException("element cannot be null");
        }
        if (element.getObjectKey() == null) {
            throw new NullPointerException("element key cannot be null");
        }
        Object key = element.getObjectKey();
        this.writeLock(key);
        try {
            Element replacedElement = element.getObjectValue() instanceof SoftLock ? this.frontEndCacheTier.replace(this.createSoftLockPlaceHolderElement(element)) : this.frontEndCacheTier.replace(element);
            if (replacedElement == null) {
                Element element2 = null;
                return element2;
            }
            Element softLockedElement = element.getObjectValue() instanceof SoftLock ? this.softLocks.put(key, element) : (Element)this.softLocks.remove(key);
            if (softLockedElement == null) {
                Element element3 = replacedElement;
                return element3;
            }
            Element element4 = softLockedElement;
            return element4;
        }
        finally {
            this.writeUnlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.writeLock();
        try {
            this.softLocks.clear();
            this.frontEndCacheTier.dispose();
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getKeys() {
        this.readLock();
        try {
            List<?> list = this.frontEndCacheTier.getKeys();
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        this.readLock();
        try {
            int n = this.frontEndCacheTier.getSize();
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTerracottaClusteredSize() {
        this.readLock();
        try {
            int n = this.frontEndCacheTier.getTerracottaClusteredSize();
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        this.readLock(key);
        try {
            boolean bl = this.frontEndCacheTier.containsKey(key);
            return bl;
        }
        finally {
            this.readUnlock(key);
        }
    }
}

