/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap;

import java.io.IOException;
import java.util.List;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.AbstractStore;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.writer.CacheWriterManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FrontEndCacheTier<T extends Store, U extends Store>
extends AbstractStore {
    protected final T cache;
    protected final U authority;

    public FrontEndCacheTier(T cache, U authority) {
        this.cache = cache;
        this.authority = authority;
    }

    protected Element copyElementForReadIfNeeded(Element element) {
        return element;
    }

    protected Element copyElementForWriteIfNeeded(Element element) {
        return element;
    }

    protected boolean isCacheFull() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element get(Object key) {
        this.readLock(key);
        try {
            Element e = this.cache.get(key);
            if (e == null && (e = this.authority.get(key)) != null) {
                this.cache.put(e);
            }
            Element element = this.copyElementForReadIfNeeded(e);
            return element;
        }
        finally {
            this.readUnlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element getQuiet(Object key) {
        this.readLock(key);
        try {
            Element e = this.cache.getQuiet(key);
            if (e == null && (e = this.authority.getQuiet(key)) != null) {
                this.cache.put(e);
            }
            Element element = this.copyElementForReadIfNeeded(e);
            return element;
        }
        finally {
            this.readUnlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(Element e) {
        Object key = e.getObjectKey();
        this.writeLock(key);
        try {
            Element copy = this.copyElementForWriteIfNeeded(e);
            if (!this.isCacheFull() || this.cache.remove(key) != null) {
                this.cache.put(copy);
            }
            boolean bl = this.authority.put(copy);
            return bl;
        }
        finally {
            this.writeUnlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putWithWriter(Element e, CacheWriterManager writer) {
        Object key = e.getObjectKey();
        this.writeLock(key);
        try {
            Element copy = this.copyElementForWriteIfNeeded(e);
            if (!this.isCacheFull() || this.cache.remove(key) != null) {
                this.cache.put(copy);
            }
            boolean bl = this.authority.putWithWriter(copy, writer);
            return bl;
        }
        finally {
            this.writeUnlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element remove(Object key) {
        this.writeLock(key);
        try {
            this.cache.remove(key);
            Element element = this.copyElementForReadIfNeeded(this.authority.remove(key));
            return element;
        }
        finally {
            this.writeUnlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element removeWithWriter(Object key, CacheWriterManager writerManager) throws CacheException {
        this.writeLock(key);
        try {
            this.cache.remove(key);
            Element element = this.copyElementForReadIfNeeded(this.authority.removeWithWriter(key, writerManager));
            return element;
        }
        finally {
            this.writeUnlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element putIfAbsent(Element e) throws NullPointerException {
        Object key = e.getObjectKey();
        this.writeLock(key);
        try {
            Element copy = this.copyElementForWriteIfNeeded(e);
            Element old = this.authority.putIfAbsent(copy);
            if (old == null) {
                if (!this.isCacheFull()) {
                    this.cache.put(copy);
                } else {
                    this.cache.remove(key);
                }
            }
            Element element = this.copyElementForReadIfNeeded(old);
            return element;
        }
        finally {
            this.writeUnlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element removeElement(Element e, ElementValueComparator comparator) throws NullPointerException {
        Object key = e.getObjectKey();
        this.writeLock(key);
        try {
            this.cache.remove(e.getObjectKey());
            Element element = this.copyElementForReadIfNeeded(this.authority.removeElement(e, comparator));
            return element;
        }
        finally {
            this.writeUnlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(Element old, Element e, ElementValueComparator comparator) throws NullPointerException, IllegalArgumentException {
        Object key = old.getObjectKey();
        this.writeLock(key);
        try {
            Element copy = this.copyElementForWriteIfNeeded(e);
            this.cache.remove(old.getObjectKey());
            boolean bl = this.authority.replace(old, copy, comparator);
            return bl;
        }
        finally {
            this.writeUnlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element replace(Element e) throws NullPointerException {
        Object key = e.getObjectKey();
        this.writeLock(key);
        try {
            Element copy = this.copyElementForWriteIfNeeded(e);
            this.cache.remove(e.getObjectKey());
            Element element = this.copyElementForReadIfNeeded(this.authority.replace(copy));
            return element;
        }
        finally {
            this.writeUnlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        this.readLock(key);
        try {
            boolean bl = this.cache.containsKey(key) || this.authority.containsKey(key);
            return bl;
        }
        finally {
            this.readUnlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKeyOnDisk(Object key) {
        this.readLock(key);
        try {
            boolean bl = this.cache.containsKeyOnDisk(key) || this.authority.containsKeyOnDisk(key);
            return bl;
        }
        finally {
            this.readUnlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKeyOffHeap(Object key) {
        this.readLock(key);
        try {
            boolean bl = this.cache.containsKeyOffHeap(key) || this.authority.containsKeyOffHeap(key);
            return bl;
        }
        finally {
            this.readUnlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKeyInMemory(Object key) {
        this.readLock(key);
        try {
            boolean bl = this.cache.containsKeyInMemory(key) || this.authority.containsKeyInMemory(key);
            return bl;
        }
        finally {
            this.readUnlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<?> getKeys() {
        this.readLock();
        try {
            List list = this.authority.getKeys();
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() throws CacheException {
        this.writeLock();
        try {
            this.cache.removeAll();
            this.authority.removeAll();
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void dispose() {
        this.cache.dispose();
        this.authority.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        this.readLock();
        try {
            int n = this.authority.getSize();
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInMemorySize() {
        this.readLock();
        try {
            int n = this.authority.getInMemorySize() + this.cache.getInMemorySize();
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOffHeapSize() {
        this.readLock();
        try {
            int n = this.authority.getOffHeapSize() + this.cache.getOffHeapSize();
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOnDiskSize() {
        this.readLock();
        try {
            int n = this.authority.getOnDiskSize() + this.cache.getOnDiskSize();
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTerracottaClusteredSize() {
        this.readLock();
        try {
            int n = this.authority.getTerracottaClusteredSize() + this.cache.getTerracottaClusteredSize();
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getInMemorySizeInBytes() {
        this.readLock();
        try {
            long l = this.authority.getInMemorySizeInBytes() + this.cache.getInMemorySizeInBytes();
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getOffHeapSizeInBytes() {
        this.readLock();
        try {
            long l = this.authority.getOffHeapSizeInBytes() + this.cache.getOffHeapSizeInBytes();
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getOnDiskSizeInBytes() {
        this.readLock();
        try {
            long l = this.authority.getOnDiskSizeInBytes() + this.cache.getOnDiskSizeInBytes();
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expireElements() {
        this.writeLock();
        try {
            this.authority.expireElements();
            this.cache.expireElements();
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void flush() throws IOException {
        this.cache.flush();
        this.authority.flush();
    }

    @Override
    public boolean bufferFull() {
        return this.cache.bufferFull() || this.authority.bufferFull();
    }

    protected abstract void readLock(Object var1);

    protected abstract void readUnlock(Object var1);

    protected abstract void writeLock(Object var1);

    protected abstract void writeUnlock(Object var1);

    protected abstract void readLock();

    protected abstract void readUnlock();

    protected abstract void writeLock();

    protected abstract void writeUnlock();
}

