/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap;

import com.terracottatech.offheapstore.exceptions.OversizeMappingException;
import java.util.HashMap;
import javax.management.NotCompliantMBeanException;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.offheap.FrontEndCacheTier;
import net.sf.ehcache.store.offheap.OnHeapFrontedOffHeapStore;
import net.sf.ehcache.store.offheap.disk.OffHeapDiskStore;
import net.sf.ehcache.store.offheap.util.CompoundingBean;
import net.sf.ehcache.writer.CacheWriterManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiskBackedOffHeapStore
extends FrontEndCacheTier<OnHeapFrontedOffHeapStore, OffHeapDiskStore> {
    public DiskBackedOffHeapStore(OnHeapFrontedOffHeapStore cache, OffHeapDiskStore authority) {
        super(cache, authority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element get(Object key) {
        Element e;
        this.readLock(key);
        try {
            e = ((OnHeapFrontedOffHeapStore)this.cache).get(key);
            if (e != null) {
                Element element = e;
                return element;
            }
        }
        finally {
            this.readUnlock(key);
        }
        this.writeLock(key);
        try {
            e = ((OnHeapFrontedOffHeapStore)this.cache).get(key);
            if (e == null && (e = ((OffHeapDiskStore)this.authority).get(key)) != null) {
                ((OnHeapFrontedOffHeapStore)this.cache).put(e);
            }
            Element element = e;
            return element;
        }
        finally {
            this.writeUnlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element getQuiet(Object key) {
        Element e;
        this.readLock(key);
        try {
            e = ((OnHeapFrontedOffHeapStore)this.cache).getQuiet(key);
            if (e != null) {
                Element element = e;
                return element;
            }
        }
        finally {
            this.readUnlock(key);
        }
        this.writeLock(key);
        try {
            e = ((OnHeapFrontedOffHeapStore)this.cache).getQuiet(key);
            if (e == null && (e = ((OffHeapDiskStore)this.authority).getQuiet(key)) != null) {
                ((OnHeapFrontedOffHeapStore)this.cache).put(e);
            }
            Element element = e;
            return element;
        }
        finally {
            this.writeUnlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(Element e) {
        Object key = e.getObjectKey();
        while (true) {
            this.writeLock(key);
            try {
                boolean bl = ((OnHeapFrontedOffHeapStore)this.cache).put(e) | ((OffHeapDiskStore)this.authority).put(e);
                this.writeUnlock(key);
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    this.writeUnlock(key);
                    throw throwable;
                }
                catch (OversizeMappingException ex) {
                    this.handleOversizeMappingException(e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putWithWriter(Element e, CacheWriterManager writer) {
        Object key = e.getObjectKey();
        while (true) {
            this.writeLock(key);
            try {
                boolean bl = ((OnHeapFrontedOffHeapStore)this.cache).put(e) | ((OffHeapDiskStore)this.authority).putWithWriter(e, writer);
                this.writeUnlock(key);
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    this.writeUnlock(key);
                    throw throwable;
                }
                catch (OversizeMappingException ex) {
                    this.handleOversizeMappingException(e);
                    continue;
                }
            }
            break;
        }
    }

    @Override
    protected void readLock(Object key) {
        ((OnHeapFrontedOffHeapStore)this.cache).readLock(key);
    }

    @Override
    protected void readUnlock(Object key) {
        ((OnHeapFrontedOffHeapStore)this.cache).readUnlock(key);
    }

    @Override
    protected void writeLock(Object key) {
        ((OnHeapFrontedOffHeapStore)this.cache).writeLock(key);
    }

    @Override
    protected void writeUnlock(Object key) {
        ((OnHeapFrontedOffHeapStore)this.cache).writeUnlock(key);
    }

    @Override
    protected void readLock() {
        ((OnHeapFrontedOffHeapStore)this.cache).readLock();
    }

    @Override
    protected void readUnlock() {
        ((OnHeapFrontedOffHeapStore)this.cache).readUnlock();
    }

    @Override
    protected void writeLock() {
        ((OnHeapFrontedOffHeapStore)this.cache).writeLock();
    }

    @Override
    protected void writeUnlock() {
        ((OnHeapFrontedOffHeapStore)this.cache).writeUnlock();
    }

    @Override
    public Status getStatus() {
        return ((OnHeapFrontedOffHeapStore)this.cache).getStatus();
    }

    @Override
    public Policy getInMemoryEvictionPolicy() {
        return ((OnHeapFrontedOffHeapStore)this.cache).getInMemoryEvictionPolicy();
    }

    @Override
    public void setInMemoryEvictionPolicy(Policy policy) {
        ((OnHeapFrontedOffHeapStore)this.cache).setInMemoryEvictionPolicy(policy);
    }

    @Override
    public Object getInternalContext() {
        return ((OnHeapFrontedOffHeapStore)this.cache).getInternalContext();
    }

    @Override
    public Object getMBean() {
        HashMap<String, Object> beans = new HashMap<String, Object>();
        beans.put("off-heap", ((OnHeapFrontedOffHeapStore)this.cache).getMBean());
        beans.put("on-disk", ((OffHeapDiskStore)this.authority).getMBean());
        try {
            return new CompoundingBean(beans);
        }
        catch (NotCompliantMBeanException ex) {
            return null;
        }
    }

    @Override
    public Element putIfAbsent(Element e) throws NullPointerException {
        while (true) {
            try {
                return super.putIfAbsent(e);
            }
            catch (OversizeMappingException ex) {
                this.handleOversizeMappingException(e);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean replace(Element old, Element e, ElementValueComparator comparator) throws NullPointerException, IllegalArgumentException {
        while (true) {
            try {
                return super.replace(old, e, comparator);
            }
            catch (OversizeMappingException ex) {
                this.handleOversizeMappingException(e);
                continue;
            }
            break;
        }
    }

    @Override
    public Element replace(Element e) throws NullPointerException {
        while (true) {
            try {
                return super.replace(e);
            }
            catch (OversizeMappingException ex) {
                this.handleOversizeMappingException(e);
                continue;
            }
            break;
        }
    }

    private void handleOversizeMappingException(Element e) {
        ((OnHeapFrontedOffHeapStore)this.cache).handleOversizeMappingException(e);
    }
}

