/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakIdentityHashMap<K, V> {
    private final Map<WeakReference<K>, V> map = new HashMap<WeakReference<K>, V>();
    private final ReferenceQueue<K> queue = new ReferenceQueue();
    private final ReaperTask<V> reaperTask;

    public WeakIdentityHashMap() {
        this(null);
    }

    public WeakIdentityHashMap(ReaperTask<V> reaperTask) {
        this.reaperTask = reaperTask;
    }

    public V put(K key, V value) {
        this.reap();
        IdentityWeakReference<K> keyRef = new IdentityWeakReference<K>(key, this.queue);
        return this.map.put(keyRef, value);
    }

    public V get(K key) {
        this.reap();
        IdentityWeakReference<K> keyRef = new IdentityWeakReference<K>(key);
        return this.map.get(keyRef);
    }

    public V remove(K key) {
        this.reap();
        IdentityWeakReference<K> keyRef = new IdentityWeakReference<K>(key);
        return this.map.remove(keyRef);
    }

    public Iterator<Map.Entry<K, V>> entries() {
        return new Iterator<Map.Entry<K, V>>(){
            private final Iterator<Map.Entry<WeakReference<K>, V>> delegate;
            {
                this.delegate = WeakIdentityHashMap.this.map.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                Map.Entry e = this.delegate.next();
                Object key = e.getKey().get();
                Object value = e.getValue();
                if (key == null) {
                    return null;
                }
                return new SimpleEntry(key, value);
            }

            @Override
            public void remove() {
                this.delegate.remove();
            }
        };
    }

    public Iterator<V> values() {
        return this.map.values().iterator();
    }

    public void reap() {
        Reference<K> ref = null;
        while ((ref = this.queue.poll()) != null) {
            V removed = this.map.remove(ref);
            if (this.reaperTask == null || removed == null) continue;
            this.reaperTask.reap(removed);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ReaperTask<T> {
        public void reap(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SimpleEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        SimpleEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IdentityWeakReference<T>
    extends WeakReference<T> {
        final int hashCode;

        IdentityWeakReference(T o) {
            this(o, (ReferenceQueue<T>)null);
        }

        IdentityWeakReference(T o, ReferenceQueue<T> q) {
            super(o, q);
            this.hashCode = o == null ? 0 : System.identityHashCode(o);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IdentityWeakReference)) {
                return false;
            }
            IdentityWeakReference wr = (IdentityWeakReference)o;
            Object got = this.get();
            return got != null && got == wr.get();
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

