/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.InvalidMarkException;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer buffer;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public int read() throws IOException {
        if (this.buffer.hasRemaining()) {
            return this.buffer.get() & 0xFF;
        }
        return -1;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int size = Math.min(len, this.buffer.remaining());
        if (size <= 0) {
            return -1;
        }
        this.buffer.get(b, off, size);
        return size;
    }

    public long skip(long n) throws IOException {
        if (n < 0L) {
            return 0L;
        }
        long skip = Math.min(n, (long)this.buffer.remaining());
        this.buffer.position((int)((long)this.buffer.position() + skip));
        return skip;
    }

    public int available() throws IOException {
        return this.buffer.remaining();
    }

    public synchronized void mark(int readlimit) {
        this.buffer.mark();
    }

    public synchronized void reset() throws IOException {
        try {
            this.buffer.reset();
        }
        catch (InvalidMarkException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public boolean markSupported() {
        return true;
    }
}

