/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.storage;

import com.terracottatech.offheapstore.OffHeapHashMap;
import com.terracottatech.offheapstore.storage.HalfStorageEngine;
import com.terracottatech.offheapstore.storage.HalfStorageEngineFactory;
import com.terracottatech.offheapstore.storage.StorageEngine;
import com.terracottatech.offheapstore.storage.StorageEngineFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitStorageEngine<K, V>
implements StorageEngine<K, V> {
    protected final HalfStorageEngine<K> keyStorageEngine;
    protected final HalfStorageEngine<V> valueStorageEngine;

    public static <K, V> StorageEngineFactory<K, V> createFactory(final HalfStorageEngineFactory<K> keyFactory, final HalfStorageEngineFactory<V> valueFactory) {
        return new StorageEngineFactory<K, V>(){

            @Override
            public StorageEngine<K, V> newInstance() {
                return new SplitStorageEngine(keyFactory.newInstance(), valueFactory.newInstance());
            }
        };
    }

    public SplitStorageEngine(HalfStorageEngine<K> keyStorageEngine, HalfStorageEngine<V> valueStorageEngine) {
        this.keyStorageEngine = keyStorageEngine;
        this.valueStorageEngine = valueStorageEngine;
    }

    @Override
    public Long writeMapping(K key, V value, int hash) {
        Integer keyEncoding = this.keyStorageEngine.write(key, hash);
        if (keyEncoding == null) {
            return null;
        }
        Integer valueEncoding = this.valueStorageEngine.write(value, hash);
        if (valueEncoding == null) {
            this.keyStorageEngine.free(keyEncoding);
            return null;
        }
        return SplitStorageEngine.encoding(keyEncoding, valueEncoding);
    }

    @Override
    public void freeMapping(long encoding) {
        this.keyStorageEngine.free(SplitStorageEngine.keyEncoding(encoding));
        this.valueStorageEngine.free(SplitStorageEngine.valueEncoding(encoding));
    }

    @Override
    public V readValue(long encoding) {
        return this.valueStorageEngine.read(SplitStorageEngine.valueEncoding(encoding));
    }

    @Override
    public boolean equalsValue(Object value, long encoding) {
        return this.valueStorageEngine.equals(value, SplitStorageEngine.valueEncoding(encoding));
    }

    @Override
    public K readKey(long encoding, int hashCode) {
        return this.keyStorageEngine.read(SplitStorageEngine.keyEncoding(encoding));
    }

    @Override
    public boolean equalsKey(Object key, long encoding) {
        return this.keyStorageEngine.equals(key, SplitStorageEngine.keyEncoding(encoding));
    }

    @Override
    public void clear() {
        this.keyStorageEngine.clear();
        this.valueStorageEngine.clear();
    }

    @Override
    public long getAllocatedMemory() {
        return this.keyStorageEngine.getAllocatedMemory() + this.valueStorageEngine.getAllocatedMemory();
    }

    @Override
    public long getOccupiedMemory() {
        return this.keyStorageEngine.getOccupiedMemory() + this.valueStorageEngine.getOccupiedMemory();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SplitStorageEngine:\n");
        sb.append("Keys:\n");
        sb.append(this.keyStorageEngine).append('\n');
        sb.append("Values:\n");
        sb.append(this.valueStorageEngine);
        return sb.toString();
    }

    @Override
    public void invalidateCache() {
        this.keyStorageEngine.invalidateCache();
        this.valueStorageEngine.invalidateCache();
    }

    @Override
    public void bind(OffHeapHashMap<?, ?> owner) {
        this.keyStorageEngine.bind(owner, -4294967296L);
        this.valueStorageEngine.bind(owner, 0xFFFFFFFFL);
    }

    @Override
    public void destroy() {
        this.keyStorageEngine.destroy();
        this.valueStorageEngine.destroy();
    }

    @Override
    public boolean shrink() {
        return this.keyStorageEngine.shrink() || this.valueStorageEngine.shrink();
    }

    public static int valueEncoding(long encoding) {
        return (int)encoding;
    }

    public static int keyEncoding(long encoding) {
        return (int)(encoding >>> 32);
    }

    public static long encoding(int keyEncoding, int valueEncoding) {
        return (long)keyEncoding << 32 | (long)valueEncoding & 0xFFFFFFFFL;
    }
}

