/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.storage;

import com.terracottatech.offheapstore.storage.HalfStorageEngine;
import com.terracottatech.offheapstore.storage.portability.Portability;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PortabilityBasedHalfStorageEngine<T>
implements HalfStorageEngine<T> {
    private final Portability<? super T> portability;
    private CachedEncode<T> lastObject;

    public PortabilityBasedHalfStorageEngine(Portability<? super T> portability) {
        this.portability = portability;
    }

    @Override
    public Integer write(T object, int hash) {
        if (this.lastObject != null && this.lastObject.get() == object) {
            return this.writeBuffer(this.lastObject.getEncoded(), hash);
        }
        ByteBuffer buffer = this.portability.encode(object);
        Integer result = this.writeBuffer(buffer, hash);
        if (result == null) {
            this.lastObject = new CachedEncode<T>(object, buffer);
        }
        return result;
    }

    @Override
    public abstract void free(int var1);

    @Override
    public T read(int encoding) {
        return this.portability.decode(this.readBuffer(encoding));
    }

    @Override
    public boolean equals(Object value, int encoding) {
        return this.portability.equals(value, this.readBuffer(encoding));
    }

    protected abstract ByteBuffer readBuffer(int var1);

    protected abstract Integer writeBuffer(ByteBuffer var1, int var2);

    @Override
    public void invalidateCache() {
        this.lastObject = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CachedEncode<T> {
        private final T object;
        private final ByteBuffer buffer;

        public CachedEncode(T object, ByteBuffer buffer) {
            this.object = object;
            this.buffer = buffer;
        }

        final T get() {
            return this.object;
        }

        final ByteBuffer getEncoded() {
            return this.buffer;
        }
    }
}

