/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.storage;

import com.terracottatech.offheapstore.AbstractLockedOffHeapHashMap;
import com.terracottatech.offheapstore.OffHeapHashMap;
import com.terracottatech.offheapstore.paging.OffHeapStorageArea;
import com.terracottatech.offheapstore.paging.PageSource;
import com.terracottatech.offheapstore.storage.HalfStorageEngine;
import com.terracottatech.offheapstore.storage.HalfStorageEngineFactory;
import com.terracottatech.offheapstore.storage.PortabilityBasedHalfStorageEngine;
import com.terracottatech.offheapstore.storage.portability.Portability;
import com.terracottatech.offheapstore.util.DebuggingUtils;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OffHeapBufferHalfStorageEngine<T>
extends PortabilityBasedHalfStorageEngine<T>
implements OffHeapStorageArea.Owner {
    private static final int KEY_HASH_OFFSET = 0;
    private static final int LENGTH_OFFSET = 4;
    private static final int DATA_OFFSET = 8;
    private static final int HEADER_LENGTH = 8;
    private volatile OffHeapHashMap<?, ?> owner;
    private volatile long mask;
    private final OffHeapStorageArea storageArea;

    public static <T> HalfStorageEngineFactory<T> createFactory(PageSource source, int pageSize, Portability<? super T> portability) {
        return OffHeapBufferHalfStorageEngine.createFactory(source, pageSize, portability, false, false);
    }

    public static <T> HalfStorageEngineFactory<T> createFactory(final PageSource source, final int pageSize, final Portability<? super T> portability, final boolean thief, final boolean victim) {
        return new HalfStorageEngineFactory<T>(){

            @Override
            public HalfStorageEngine<T> newInstance() {
                return new OffHeapBufferHalfStorageEngine(source, pageSize, portability, thief, victim);
            }
        };
    }

    public OffHeapBufferHalfStorageEngine(PageSource source, int pageSize, Portability<? super T> portability) {
        this(source, pageSize, portability, false, false);
    }

    public OffHeapBufferHalfStorageEngine(PageSource source, int pageSize, Portability<? super T> portability, boolean thief, boolean victim) {
        super(portability);
        this.storageArea = new OffHeapStorageArea(this, source, pageSize, thief, victim);
    }

    @Override
    public void clear() {
        this.storageArea.clear();
    }

    @Override
    public void free(int address) {
        this.storageArea.free(address);
    }

    @Override
    protected ByteBuffer readBuffer(int address) {
        int length = this.storageArea.readInt(address + 4);
        return this.storageArea.readBuffer(address + 8, length);
    }

    @Override
    protected Integer writeBuffer(ByteBuffer buffer, int hash) {
        int length = buffer.remaining();
        int address = this.storageArea.allocate(length + 8);
        if (address >= 0) {
            this.storageArea.writeInt(address + 0, hash);
            this.storageArea.writeInt(address + 4, length);
            this.storageArea.writeBuffer(address + 8, buffer);
            return address;
        }
        return null;
    }

    @Override
    public long getAllocatedMemory() {
        return this.storageArea.getAllocatedMemory();
    }

    @Override
    public long getOccupiedMemory() {
        return this.storageArea.getOccupiedMemory();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OffHeapBufferStorageEngine ");
        sb.append("allocated=").append(DebuggingUtils.toBase2SuffixedString(this.getAllocatedMemory())).append("B ");
        sb.append("occupied=").append(DebuggingUtils.toBase2SuffixedString(this.getOccupiedMemory())).append("B\n");
        sb.append("Allocator: ").append(this.storageArea);
        return sb.toString();
    }

    @Override
    public void bind(OffHeapHashMap<?, ?> o, long m) {
        if (this.owner != null) {
            throw new AssertionError();
        }
        this.owner = o;
        this.mask = m;
    }

    @Override
    public void destroy() {
        this.storageArea.destroy();
    }

    @Override
    public boolean shrink() {
        return this.storageArea.shrink();
    }

    @Override
    public void removeAtAddress(int address) {
        int hash = this.storageArea.readInt(address + 0);
        int slot = this.owner.getSlotForHashAndEncoding(hash, address, this.mask);
        this.owner.evict(slot, true);
    }

    @Override
    public void writeLock() {
        if (this.owner instanceof AbstractLockedOffHeapHashMap) {
            ((AbstractLockedOffHeapHashMap)this.owner).getWriteLock().lock();
        }
    }

    @Override
    public void writeUnlock() {
        if (this.owner instanceof AbstractLockedOffHeapHashMap) {
            ((AbstractLockedOffHeapHashMap)this.owner).getWriteLock().unlock();
        }
    }
}

