/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.paging;

import com.terracottatech.offheapstore.paging.OffHeapStorageArea;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class Page {
    private final ByteBuffer buffer;
    private OffHeapStorageArea binding;

    public Page(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public ByteBuffer asByteBuffer() {
        return this.buffer;
    }

    public IntBuffer asIntBuffer() {
        return this.buffer.asIntBuffer();
    }

    public int size() {
        return this.buffer.capacity();
    }

    public synchronized OffHeapStorageArea unbind() {
        OffHeapStorageArea b = this.binding;
        this.binding = null;
        return b;
    }

    public synchronized void bind(OffHeapStorageArea b) {
        if (this.binding != null) {
            throw new AssertionError();
        }
        this.binding = b;
    }
}

