/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.disk.storage.portability;

import com.terracottatech.offheapstore.disk.persistent.PersistentPortability;
import com.terracottatech.offheapstore.storage.portability.SerializablePortability;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentSerializablePortability
extends SerializablePortability
implements PersistentPortability<Serializable> {
    private static final int MAGIC = -17973521;

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persist(ObjectOutput output) throws IOException {
        output.writeInt(-17973521);
        ConcurrentMap concurrentMap = this.lookup;
        synchronized (concurrentMap) {
            for (Map.Entry e : this.lookup.entrySet()) {
                if (!(e.getKey() instanceof Integer)) continue;
                output.writeInt((Integer)e.getKey());
                output.writeObject(e.getValue());
            }
            output.writeInt(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bootstrap(ObjectInput input) throws IOException {
        if (input.readInt() != -17973521) {
            throw new IOException("Wrong magic number");
        }
        ConcurrentMap concurrentMap = this.lookup;
        synchronized (concurrentMap) {
            int representation;
            while ((representation = input.readInt()) != -1) {
                Integer oldRep;
                ObjectStreamClass osc;
                try {
                    osc = (ObjectStreamClass)input.readObject();
                }
                catch (ClassNotFoundException e) {
                    IOException ioe = new IOException();
                    ioe.initCause(e);
                    throw ioe;
                }
                SerializablePortability.SerializableDataKey key = new SerializablePortability.SerializableDataKey(osc);
                ObjectStreamClass oldOsc = this.lookup.putIfAbsent(representation, osc);
                if (!(oldOsc == null ^ (oldRep = this.lookup.putIfAbsent(key, representation)) == null)) continue;
                throw new IOException("Existing corrupted class mapping detected");
            }
        }
    }
}

