/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.disk.persistent;

import com.terracottatech.offheapstore.AbstractLockedOffHeapHashMap;
import com.terracottatech.offheapstore.disk.paging.MappedPageSource;
import com.terracottatech.offheapstore.disk.persistent.Persistent;
import com.terracottatech.offheapstore.disk.persistent.PersistentStorageEngine;
import com.terracottatech.offheapstore.paging.PageSource;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.MappedByteBuffer;
import java.util.concurrent.locks.Lock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPersistentLockedOffHeapHashMap<K, V>
extends AbstractLockedOffHeapHashMap<K, V>
implements Persistent {
    private static final int MAGIC = 1212502615;

    public AbstractPersistentLockedOffHeapHashMap(MappedPageSource tableSource, PersistentStorageEngine<? super K, ? super V> storageEngine, boolean bootstrap) {
        super((PageSource)tableSource, storageEngine, bootstrap);
    }

    public AbstractPersistentLockedOffHeapHashMap(MappedPageSource tableSource, PersistentStorageEngine<? super K, ? super V> storageEngine, int tableSize, boolean bootstrap) {
        super((PageSource)tableSource, storageEngine, tableSize, bootstrap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Lock l = this.getWriteLock();
        l.lock();
        try {
            ((MappedByteBuffer)this.hashTablePage.asByteBuffer()).force();
            ((Persistent)((Object)this.storageEngine)).flush();
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Lock l = this.getWriteLock();
        l.lock();
        try {
            ((MappedPageSource)this.tableSource).close();
            ((Persistent)((Object)this.storageEngine)).close();
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persist(ObjectOutput output) throws IOException {
        Lock l = this.getWriteLock();
        l.lock();
        try {
            output.writeInt(1212502615);
            output.writeLong(((MappedPageSource)this.tableSource).getAddress(this.hashTablePage));
            output.writeInt(this.hashTablePage.size());
            output.writeInt(this.reprobeLimit);
            ((Persistent)((Object)this.storageEngine)).persist(output);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bootstrap(ObjectInput input) throws IOException {
        Lock l = this.getWriteLock();
        l.lock();
        try {
            if (this.hashtable != null) {
                throw new IllegalStateException();
            }
            if (input.readInt() != 1212502615) {
                throw new IOException("Wrong magic number");
            }
            long tableAddress = input.readLong();
            long tableCapacity = input.readInt();
            this.hashTablePage = ((MappedPageSource)this.tableSource).claimPage(tableAddress, tableCapacity);
            this.hashtable = this.hashTablePage.asIntBuffer();
            this.reprobeLimit = input.readInt();
            int[] entry = new int[4];
            this.hashtable.clear();
            while (this.hashtable.hasRemaining()) {
                this.hashtable.get(entry);
                if (AbstractPersistentLockedOffHeapHashMap.isPresent(entry)) {
                    ++this.size;
                    continue;
                }
                if (!AbstractPersistentLockedOffHeapHashMap.isRemoved(entry)) continue;
                ++this.removedSlots;
            }
            ((Persistent)((Object)this.storageEngine)).bootstrap(input);
        }
        finally {
            l.unlock();
        }
    }
}

