/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.disk.persistent;

import com.terracottatech.offheapstore.Segment;
import com.terracottatech.offheapstore.concurrent.AbstractConcurrentOffHeapMap;
import com.terracottatech.offheapstore.concurrent.SegmentFactory;
import com.terracottatech.offheapstore.disk.persistent.Persistent;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPersistentConcurrentOffHeapMap<K, V>
extends AbstractConcurrentOffHeapMap<K, V>
implements Persistent {
    private static final int MAGIC = 1463898952;

    public AbstractPersistentConcurrentOffHeapMap(SegmentFactory<K, V> segmentFactory, boolean latencyMonitoring) {
        super(segmentFactory, latencyMonitoring);
    }

    public AbstractPersistentConcurrentOffHeapMap(SegmentFactory<K, V> segmentFactory, int concurrency, boolean latencyMonitoring) {
        super(segmentFactory, concurrency, latencyMonitoring);
    }

    @Override
    public void flush() throws IOException {
        for (Segment s : this.segments) {
            ((Persistent)((Object)s)).flush();
        }
    }

    @Override
    public void persist(ObjectOutput output) throws IOException {
        output.writeInt(1463898952);
        output.writeInt(this.segments.length);
        for (Segment s : this.segments) {
            ((Persistent)((Object)s)).persist(output);
        }
    }

    @Override
    public void close() throws IOException {
        for (Segment s : this.segments) {
            ((Persistent)((Object)s)).close();
        }
    }

    @Override
    public void bootstrap(ObjectInput input) throws IOException {
        for (Segment s : this.segments) {
            ((Persistent)((Object)s)).bootstrap(input);
        }
    }

    protected static int readSegmentCount(ObjectInput input) throws IOException {
        if (input.readInt() != 1463898952) {
            throw new IOException("Wrong magic number");
        }
        return input.readInt();
    }
}

