/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.concurrent;

import com.terracottatech.offheapstore.WriteLockedOffHeapHashMap;
import com.terracottatech.offheapstore.concurrent.SegmentFactory;
import com.terracottatech.offheapstore.paging.PageSource;
import com.terracottatech.offheapstore.storage.StorageEngine;
import com.terracottatech.offheapstore.storage.StorageEngineFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WriteLockedOffHeapHashMapFactory<K, V>
implements SegmentFactory<K, V> {
    private static final int DEFAULT_TABLE_SIZE = 128;
    private final StorageEngineFactory<? super K, ? super V> storageEngineFactory;
    private final PageSource tableSource;
    private final int tableSize;

    public WriteLockedOffHeapHashMapFactory(PageSource tableSource, StorageEngineFactory<? super K, ? super V> storageEngineFactory) {
        this(tableSource, storageEngineFactory, 128);
    }

    public WriteLockedOffHeapHashMapFactory(PageSource tableSource, StorageEngineFactory<? super K, ? super V> storageEngineFactory, int tableSize) {
        this.storageEngineFactory = storageEngineFactory;
        this.tableSource = tableSource;
        this.tableSize = tableSize;
    }

    @Override
    public WriteLockedOffHeapHashMap<K, V> newInstance() {
        StorageEngine<K, V> storageEngine = this.storageEngineFactory.newInstance();
        try {
            return new WriteLockedOffHeapHashMap<K, V>(this.tableSource, storageEngine, this.tableSize);
        }
        catch (RuntimeException e) {
            storageEngine.destroy();
            throw e;
        }
    }
}

