/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.concurrent;

import com.terracottatech.offheapstore.ReadWriteLockedOffHeapHashMap;
import com.terracottatech.offheapstore.concurrent.SegmentFactory;
import com.terracottatech.offheapstore.paging.PageSource;
import com.terracottatech.offheapstore.storage.StorageEngine;
import com.terracottatech.offheapstore.storage.StorageEngineFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadWriteLockedOffHeapHashMapFactory<K, V>
implements SegmentFactory<K, V> {
    private static final int DEFAULT_TABLE_SIZE = 128;
    private final StorageEngineFactory<? super K, ? super V> storageEngineFactory;
    private final PageSource tableSource;
    private final boolean tableAllocationsSteal;
    private final int tableSize;

    public ReadWriteLockedOffHeapHashMapFactory(PageSource tableSource, StorageEngineFactory<? super K, ? super V> storageEngineFactory) {
        this(tableSource, false, storageEngineFactory, 128);
    }

    public ReadWriteLockedOffHeapHashMapFactory(PageSource tableSource, boolean tableAllocationsSteal, StorageEngineFactory<? super K, ? super V> storageEngineFactory) {
        this(tableSource, tableAllocationsSteal, storageEngineFactory, 128);
    }

    public ReadWriteLockedOffHeapHashMapFactory(PageSource tableSource, StorageEngineFactory<? super K, ? super V> storageEngineFactory, int tableSize) {
        this(tableSource, false, storageEngineFactory, tableSize);
    }

    public ReadWriteLockedOffHeapHashMapFactory(PageSource tableSource, boolean tableAllocationsSteal, StorageEngineFactory<? super K, ? super V> storageEngineFactory, int tableSize) {
        this.storageEngineFactory = storageEngineFactory;
        this.tableSource = tableSource;
        this.tableAllocationsSteal = tableAllocationsSteal;
        this.tableSize = tableSize;
    }

    @Override
    public ReadWriteLockedOffHeapHashMap<K, V> newInstance() {
        StorageEngine<K, V> storageEngine = this.storageEngineFactory.newInstance();
        try {
            return new ReadWriteLockedOffHeapHashMap<K, V>(this.tableSource, this.tableAllocationsSteal, storageEngine, this.tableSize);
        }
        catch (RuntimeException e) {
            storageEngine.destroy();
            throw e;
        }
    }
}

