/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore;

import com.terracottatech.offheapstore.paging.Page;
import com.terracottatech.offheapstore.paging.PageSource;
import com.terracottatech.offheapstore.statistics.MapStatistics;
import com.terracottatech.offheapstore.storage.StorageEngine;
import com.terracottatech.offheapstore.util.DebuggingUtils;
import com.terracottatech.offheapstore.util.WeakIdentityHashMap;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OffHeapHashMap<K, V>
extends AbstractMap<K, V>
implements MapStatistics {
    private static final Logger LOGGER = LoggerFactory.getLogger(OffHeapHashMap.class);
    private static final int INITIAL_TABLE_SIZE = 128;
    private static final float TABLE_RESIZE_THRESHOLD = 0.5f;
    private static final float TABLE_SHRINK_THRESHOLD = 0.2f;
    private static final int INITIAL_REPROBE_LENGTH = 16;
    private static final int BULK_ENTRY_READ = 1024;
    protected static final int ENTRY_SIZE = 4;
    private static final int ENTRY_BIT_SHIFT = Integer.numberOfTrailingZeros(4);
    protected static final int STATUS = 0;
    private static final int KEY_HASHCODE = 1;
    private static final int ENCODING = 2;
    protected static final int STATUS_USED = 1;
    private static final int STATUS_REMOVED = 2;
    protected final StorageEngine<? super K, ? super V> storageEngine;
    protected final PageSource tableSource;
    private final WeakIdentityHashMap<IntBuffer, PendingPage> pendingTableFrees = new WeakIdentityHashMap(new WeakIdentityHashMap.ReaperTask<PendingPage>(){

        @Override
        public void reap(PendingPage pending) {
            OffHeapHashMap.this.freeTable(pending.tablePage);
        }
    });
    private final int initialTableSize;
    private final boolean tableAllocationsSteal;
    protected volatile int size;
    protected volatile int modCount;
    protected int reprobeLimit = 16;
    private float currentTableShrinkThreshold = 0.2f;
    private volatile boolean hasUsedIterators;
    protected volatile IntBuffer hashtable;
    protected volatile Page hashTablePage;
    private Set<Map.Entry<K, V>> entrySet;
    private Set<K> keySet;
    protected volatile int removedSlots;
    private volatile long putCount = 0L;
    private final AtomicLong missCount = new AtomicLong();
    private final AtomicLong hitCount = new AtomicLong();

    public OffHeapHashMap(PageSource source, StorageEngine<? super K, ? super V> storageEngine) {
        this(source, storageEngine, 128);
    }

    public OffHeapHashMap(PageSource source, boolean tableAllocationsSteal, StorageEngine<? super K, ? super V> storageEngine) {
        this(source, tableAllocationsSteal, storageEngine, 128);
    }

    public OffHeapHashMap(PageSource source, StorageEngine<? super K, ? super V> storageEngine, boolean bootstrap) {
        this(source, false, storageEngine, 128, bootstrap);
    }

    public OffHeapHashMap(PageSource source, StorageEngine<? super K, ? super V> storageEngine, int tableSize) {
        this(source, false, storageEngine, tableSize, true);
    }

    public OffHeapHashMap(PageSource source, boolean tableAllocationsSteal, StorageEngine<? super K, ? super V> storageEngine, int tableSize) {
        this(source, tableAllocationsSteal, storageEngine, tableSize, true);
    }

    protected OffHeapHashMap(PageSource source, boolean tableAllocationsSteal, StorageEngine<? super K, ? super V> storageEngine, int tableSize, boolean bootstrap) {
        int capacity;
        if (storageEngine == null) {
            throw new NullPointerException("StorageEngine implementation must be non-null");
        }
        this.storageEngine = storageEngine;
        this.tableSource = source;
        this.tableAllocationsSteal = tableAllocationsSteal;
        for (capacity = 1; capacity < tableSize; capacity <<= 1) {
        }
        this.initialTableSize = capacity;
        if (bootstrap) {
            this.hashTablePage = this.allocateTable(this.initialTableSize);
            if (this.hashTablePage == null) {
                StringBuilder sb = new StringBuilder("Initial table allocation failed.\n");
                sb.append("Initial Table Size (slots) : ").append(this.initialTableSize).append('\n');
                sb.append("Allocation Will Require    : ").append(DebuggingUtils.toBase2SuffixedString(this.initialTableSize * 4 * 4)).append("B\n");
                sb.append("Table Page Source        : ").append(this.tableSource);
                throw new IllegalArgumentException(sb.toString());
            }
            this.hashtable = this.hashTablePage.asIntBuffer();
        }
        this.storageEngine.bind(this);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsKey(Object key) {
        int hash = key.hashCode();
        IntBuffer view = (IntBuffer)this.hashtable.duplicate().position(this.indexFor(OffHeapHashMap.spread(hash)));
        int[] entry = new int[4];
        int limit = this.reprobeLimit();
        for (int i = 0; i < limit; ++i) {
            if (!view.hasRemaining()) {
                view.rewind();
            }
            view.get(entry);
            if (OffHeapHashMap.isTerminating(entry)) {
                this.missCount.incrementAndGet();
                return false;
            }
            if (!OffHeapHashMap.isPresent(entry) || !this.keyEquals(key, hash, OffHeapHashMap.readLong(entry, 2), entry[1])) continue;
            this.hit(view.position() - 4);
            this.hitCount.incrementAndGet();
            return true;
        }
        this.missCount.incrementAndGet();
        return false;
    }

    @Override
    public V get(Object key) {
        int hash = key.hashCode();
        IntBuffer view = (IntBuffer)this.hashtable.duplicate().position(this.indexFor(OffHeapHashMap.spread(hash)));
        int[] entry = new int[4];
        int limit = this.reprobeLimit();
        for (int i = 0; i < limit; ++i) {
            if (!view.hasRemaining()) {
                view.rewind();
            }
            view.get(entry);
            if (OffHeapHashMap.isTerminating(entry)) {
                this.missCount.incrementAndGet();
                return null;
            }
            if (!OffHeapHashMap.isPresent(entry) || !this.keyEquals(key, hash, OffHeapHashMap.readLong(entry, 2), entry[1])) continue;
            this.hit(view.position() - 4);
            this.hitCount.incrementAndGet();
            return this.storageEngine.readValue(OffHeapHashMap.readLong(entry, 2));
        }
        this.missCount.incrementAndGet();
        return null;
    }

    @Override
    public V put(K key, V value) {
        this.freePendingTables();
        int hash = key.hashCode();
        int start = this.indexFor(OffHeapHashMap.spread(hash));
        this.hashtable.position(start);
        int[] entry = new int[4];
        int limit = this.reprobeLimit();
        for (int i = 0; i < limit; ++i) {
            if (!this.hashtable.hasRemaining()) {
                this.hashtable.rewind();
            }
            this.hashtable.get(entry);
            if (OffHeapHashMap.isAvailable(entry)) {
                if (OffHeapHashMap.isRemoved(entry)) {
                    --this.removedSlots;
                }
                int slot = this.hashtable.position() - 4;
                V old = null;
                while (i < limit && !OffHeapHashMap.isTerminating(entry)) {
                    if (OffHeapHashMap.isPresent(entry) && this.keyEquals(key, hash, OffHeapHashMap.readLong(entry, 2), entry[1])) {
                        int oldSlot = this.hashtable.position() - 4;
                        old = this.storageEngine.readValue(OffHeapHashMap.readLong(entry, 2));
                        this.storageEngine.freeMapping(OffHeapHashMap.readLong(entry, 2));
                        this.hashtable.position(oldSlot);
                        this.hashtable.put(2);
                        this.slotRemoved(oldSlot);
                        break;
                    }
                    if (!this.hashtable.hasRemaining()) {
                        this.hashtable.rewind();
                    }
                    this.hashtable.get(entry);
                    ++i;
                }
                this.hashtable.position(slot);
                this.hashtable.put(this.writeNewEntry(key, hash, value, slot));
                this.slotAdded(slot);
                this.hit(slot);
                return old;
            }
            if (!this.keyEquals(key, hash, OffHeapHashMap.readLong(entry, 2), entry[1])) continue;
            int slot = this.hashtable.position() - 4;
            this.hashtable.position(slot);
            this.hashtable.put(this.writeNewEntry(key, hash, value, slot));
            V old = this.storageEngine.readValue(OffHeapHashMap.readLong(entry, 2));
            this.storageEngine.freeMapping(OffHeapHashMap.readLong(entry, 2));
            ++this.modCount;
            ++this.putCount;
            this.hit(slot);
            return old;
        }
        this.expand(start, limit);
        return this.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] writeNewEntry(K key, int hash, V value, int activeIndex) {
        try {
            Long encoding;
            while ((encoding = this.storageEngine.writeMapping(key, value, hash)) == null) {
                this.storageEngineFailure(activeIndex, key);
            }
            int[] nArray = new int[]{1, hash, (int)(encoding >>> 32), encoding.intValue()};
            return nArray;
        }
        finally {
            this.storageEngine.invalidateCache();
        }
    }

    @Override
    public V remove(Object key) {
        this.freePendingTables();
        int hash = key.hashCode();
        this.hashtable.position(this.indexFor(OffHeapHashMap.spread(hash)));
        int[] entry = new int[4];
        int limit = this.reprobeLimit();
        for (int i = 0; i < limit; ++i) {
            if (!this.hashtable.hasRemaining()) {
                this.hashtable.rewind();
            }
            this.hashtable.get(entry);
            if (OffHeapHashMap.isTerminating(entry)) {
                return null;
            }
            if (!OffHeapHashMap.isPresent(entry) || !this.keyEquals(key, hash, OffHeapHashMap.readLong(entry, 2), entry[1])) continue;
            int removedSlot = this.hashtable.position() - 4;
            V removedValue = this.storageEngine.readValue(OffHeapHashMap.readLong(entry, 2));
            this.storageEngine.freeMapping(OffHeapHashMap.readLong(entry, 2));
            this.hashtable.position(removedSlot);
            this.hashtable.put(2);
            this.slotRemoved(removedSlot);
            this.shrink();
            return removedValue;
        }
        return null;
    }

    @Override
    public void clear() {
        this.freePendingTables();
        ++this.modCount;
        this.removedSlots = 0;
        this.size = 0;
        this.allocateOrClearTable(this.initialTableSize);
        this.storageEngine.clear();
    }

    public void destroy() {
        this.removedSlots = 0;
        this.size = 0;
        this.freeTable(this.hashTablePage);
        Iterator<PendingPage> it = this.pendingTableFrees.values();
        while (it.hasNext()) {
            this.freeTable(it.next().tablePage);
        }
        this.hashTablePage = null;
        this.hashtable = null;
        this.storageEngine.destroy();
    }

    private void allocateOrClearTable(int size) {
        Page newTablePage = this.allocateTable(size);
        if (newTablePage == null) {
            int[] zeros = new int[256];
            this.hashtable.clear();
            while (this.hashtable.hasRemaining()) {
                if (this.hashtable.remaining() < zeros.length) {
                    this.hashtable.put(zeros, 0, this.hashtable.remaining());
                    continue;
                }
                this.hashtable.put(zeros);
            }
            this.hashtable.clear();
        } else {
            this.freeTable(this.hashTablePage, this.hashtable, this.reprobeLimit());
            this.hashTablePage = newTablePage;
            this.hashtable = newTablePage.asIntBuffer();
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es == null ? (this.entrySet = new EntrySet()) : es;
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks == null ? (this.keySet = new KeySet()) : ks;
    }

    protected static boolean isPresent(int[] entry) {
        return OffHeapHashMap.isPresent(entry, 0);
    }

    protected static boolean isPresent(int[] entries, int offset) {
        return (entries[0 + offset] & 1) != 0;
    }

    protected static boolean isAvailable(int[] entry) {
        return (entry[0] & 1) == 0;
    }

    protected static boolean isTerminating(int[] entry) {
        return OffHeapHashMap.isTerminating(entry[0]);
    }

    private static boolean isTerminating(int entryStatus) {
        return (entryStatus & 3) == 0;
    }

    protected static boolean isRemoved(int[] entry) {
        return OffHeapHashMap.isRemoved(entry[0]);
    }

    private static boolean isRemoved(int entryStatus) {
        return (entryStatus & 2) != 0;
    }

    private static long readLong(int[] array, int offset) {
        return (long)array[offset] << 32 | 0xFFFFFFFFL & (long)array[offset + 1];
    }

    private int indexFor(int hash) {
        return OffHeapHashMap.indexFor(hash, this.hashtable);
    }

    private static int indexFor(int hash, IntBuffer table) {
        return hash << ENTRY_BIT_SHIFT & table.capacity() - 1;
    }

    private boolean keyEquals(Object probeKey, int probeHash, long targetEncoding, int targetHash) {
        return probeHash == targetHash && this.storageEngine.equalsKey(probeKey, targetEncoding);
    }

    private void expand(int start, int length) {
        if ((float)this.size / (float)this.getTableCapacity() > 0.5f) {
            this.expandTable(start, length);
        } else {
            this.increaseReprobe();
        }
    }

    private void expandTable(int start, int length) {
        Page newTablePage = this.expandTable(1);
        if (newTablePage == null) {
            this.tableExpansionFailure(start, length);
        } else {
            this.freeTable(this.hashTablePage, this.hashtable, this.reprobeLimit());
            this.hashTablePage = newTablePage;
            this.hashtable = newTablePage.asIntBuffer();
            this.removedSlots = 0;
        }
    }

    private Page expandTable(int scale) {
        Page newTablePage;
        int newsize = this.hashtable.capacity() << scale;
        if (newsize <= 0) {
            return null;
        }
        long startTime = -1L;
        if (LOGGER.isDebugEnabled()) {
            startTime = System.nanoTime();
            int slots = this.hashtable.capacity() / 4;
            int newslots = newsize / 4;
            LOGGER.debug("Expanding table from {} slots to {} slots [load-factor={}]", new Object[]{DebuggingUtils.toBase2SuffixedString(slots), DebuggingUtils.toBase2SuffixedString(newslots), Float.valueOf((float)this.size / (float)slots)});
        }
        if ((newTablePage = this.allocateTable(newsize / 4)) == null) {
            return null;
        }
        IntBuffer newTable = newTablePage.asIntBuffer();
        int[] entries = new int[4096];
        this.hashtable.clear();
        while (this.hashtable.hasRemaining()) {
            if (this.hashtable.remaining() < entries.length) {
                entries = new int[this.hashtable.remaining()];
            }
            this.hashtable.get(entries);
            for (int offset = 0; offset < entries.length; offset += 4) {
                if (!OffHeapHashMap.isPresent(entries, offset) || this.writeEntry(newTable, entries, offset)) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Table expansion from {} slots to {} slots abandoned - not enough table space", (Object)DebuggingUtils.toBase2SuffixedString(this.hashtable.capacity() / 4), (Object)DebuggingUtils.toBase2SuffixedString(newsize / 4));
                }
                this.freeTable(newTablePage);
                return this.expandTable(scale + 1);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            long time = System.nanoTime() - startTime;
            LOGGER.debug("Table expansion from {} slots to {} slots complete : took {}ms", new Object[]{DebuggingUtils.toBase2SuffixedString(this.hashtable.capacity() / 4), DebuggingUtils.toBase2SuffixedString(newsize / 4), Float.valueOf((float)time / 1000000.0f)});
        }
        return newTablePage;
    }

    private void increaseReprobe() {
        int newReprobeLimit = this.reprobeLimit() << 1;
        if (LOGGER.isDebugEnabled()) {
            int slots = this.hashtable.capacity() / 4;
            LOGGER.debug("Expanding reprobe sequence from {} slots to {} slots [load-factor={}]", new Object[]{this.reprobeLimit(), newReprobeLimit, Float.valueOf((float)this.size / (float)slots)});
        }
        this.reprobeLimit = newReprobeLimit;
    }

    private void shrink() {
        if ((float)this.size / (float)this.getTableCapacity() <= this.currentTableShrinkThreshold) {
            this.shrinkTable();
        }
    }

    private void shrinkTable() {
        float shrinkRatio = 0.5f * (float)this.getTableCapacity() / (float)this.size;
        int shrinkShift = Integer.numberOfTrailingZeros(Integer.highestOneBit(Math.max(2, (int)shrinkRatio)));
        Page newTablePage = this.shrinkTable(shrinkShift);
        if (newTablePage == null) {
            this.currentTableShrinkThreshold /= 2.0f;
        } else {
            this.currentTableShrinkThreshold = 0.2f;
            this.freeTable(this.hashTablePage, this.hashtable, this.reprobeLimit());
            this.hashTablePage = newTablePage;
            this.hashtable = newTablePage.asIntBuffer();
            this.removedSlots = 0;
        }
    }

    private Page shrinkTable(int scale) {
        Page newTablePage;
        int newsize = this.hashtable.capacity() >>> scale;
        if (newsize < 4) {
            if (scale > 1) {
                return this.shrinkTable(scale - 1);
            }
            return null;
        }
        long startTime = -1L;
        if (LOGGER.isDebugEnabled()) {
            startTime = System.nanoTime();
            int slots = this.hashtable.capacity() / 4;
            int newslots = newsize / 4;
            LOGGER.debug("Shrinking table from {} slots to {} slots [load-factor={}]", new Object[]{DebuggingUtils.toBase2SuffixedString(slots), DebuggingUtils.toBase2SuffixedString(newslots), Float.valueOf((float)this.size / (float)slots)});
        }
        if ((newTablePage = this.allocateTable(newsize / 4)) == null) {
            return null;
        }
        IntBuffer newTable = newTablePage.asIntBuffer();
        int[] entries = new int[4096];
        this.hashtable.clear();
        while (this.hashtable.hasRemaining()) {
            if (this.hashtable.remaining() < entries.length) {
                entries = new int[this.hashtable.remaining()];
            }
            this.hashtable.get(entries);
            for (int offset = 0; offset < entries.length; offset += 4) {
                if (!OffHeapHashMap.isPresent(entries, offset) || this.writeEntry(newTable, entries, offset)) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Table shrinking from {} slots to {} slots abandoned - too little table space", (Object)DebuggingUtils.toBase2SuffixedString(this.hashtable.capacity() / 4), (Object)DebuggingUtils.toBase2SuffixedString(newsize / 4));
                }
                this.freeTable(newTablePage);
                if (scale > 1) {
                    return this.shrinkTable(scale - 1);
                }
                this.hashtable.clear();
                return null;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            long time = System.nanoTime() - startTime;
            LOGGER.debug("Table shrinking from {} slots to {} slots complete : took {}ms", new Object[]{DebuggingUtils.toBase2SuffixedString(this.hashtable.capacity() / 4), DebuggingUtils.toBase2SuffixedString(newsize / 4), Float.valueOf((float)time / 1000000.0f)});
        }
        return newTablePage;
    }

    private boolean writeEntry(IntBuffer table, int[] entries, int offset) {
        int start = OffHeapHashMap.indexFor(OffHeapHashMap.spread(entries[offset + 1]), table);
        int tableMask = table.capacity() - 1;
        for (int i = 0; i < this.reprobeLimit() * 4; i += 4) {
            int address = start + i & tableMask;
            int existingStatus = table.get(address + 0);
            if (OffHeapHashMap.isTerminating(existingStatus)) {
                table.position(address);
                table.put(entries, offset, 4);
                return true;
            }
            if (OffHeapHashMap.isRemoved(existingStatus)) {
                throw new AssertionError();
            }
        }
        return false;
    }

    protected static int spread(int hash) {
        int h = hash;
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    private Page allocateTable(int size) {
        Page newTablePage = this.tableSource.allocate(size * 4 * 4, this.tableAllocationsSteal, false, null);
        if (newTablePage != null) {
            ByteBuffer buffer = newTablePage.asByteBuffer();
            byte[] zeros = new byte[1024];
            buffer.clear();
            while (buffer.hasRemaining()) {
                if (buffer.remaining() < zeros.length) {
                    buffer.put(zeros, 0, buffer.remaining());
                    continue;
                }
                buffer.put(zeros);
            }
            buffer.clear();
        }
        return newTablePage;
    }

    private void freeTable(Page tablePage, IntBuffer table, int finalReprobe) {
        if (this.hasUsedIterators) {
            this.pendingTableFrees.put(table, new PendingPage(tablePage, finalReprobe));
        } else {
            this.freeTable(tablePage);
        }
    }

    private void freeTable(Page tablePage) {
        this.tableSource.free(tablePage);
    }

    private int reprobeLimit() {
        return this.reprobeLimit;
    }

    private void freePendingTables() {
        if (this.hasUsedIterators) {
            this.pendingTableFrees.reap();
        }
    }

    private static boolean visited(int[] check, RetiredTable retired) {
        int hash = check[1];
        long encoding = OffHeapHashMap.readLong(check, 2);
        IntBuffer view = retired.table.asReadOnlyBuffer();
        int position = OffHeapHashMap.indexFor(OffHeapHashMap.spread(hash), view);
        int limit = retired.reprobe;
        if (position > view.limit()) {
            view.position(0);
            limit -= (view.capacity() - position) / 4;
        } else {
            view.position(position);
        }
        int[] entry = new int[4];
        for (int i = 0; i < limit; ++i) {
            if (!view.hasRemaining()) {
                i += (view.capacity() - view.limit()) / 4;
                view.rewind();
            }
            view.get(entry);
            if (OffHeapHashMap.isTerminating(entry)) break;
            if (!OffHeapHashMap.isPresent(entry) || hash != entry[1] || encoding != OffHeapHashMap.readLong(entry, 2)) continue;
            return true;
        }
        return false;
    }

    boolean removeMapping(Object o) {
        this.freePendingTables();
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        Map.Entry e = (Map.Entry)o;
        Object key = e.getKey();
        int hash = key.hashCode();
        this.hashtable.position(this.indexFor(OffHeapHashMap.spread(hash)));
        int[] entry = new int[4];
        for (int i = 0; i < this.reprobeLimit(); ++i) {
            if (!this.hashtable.hasRemaining()) {
                this.hashtable.rewind();
            }
            this.hashtable.get(entry);
            if (OffHeapHashMap.isTerminating(entry)) {
                return false;
            }
            if (!OffHeapHashMap.isPresent(entry) || !this.keyEquals(key, hash, OffHeapHashMap.readLong(entry, 2), entry[1]) || !this.storageEngine.equalsValue(e.getValue(), OffHeapHashMap.readLong(entry, 2))) continue;
            int removedSlot = this.hashtable.position() - 4;
            this.storageEngine.freeMapping(OffHeapHashMap.readLong(entry, 2));
            this.hashtable.position(removedSlot);
            this.hashtable.put(2);
            this.slotRemoved(removedSlot);
            this.shrink();
            return true;
        }
        return false;
    }

    public void evict(int index, boolean shrink) {
        this.freePendingTables();
        this.removeAtTableOffset(index, shrink);
    }

    private void removeAtTableOffset(int offset, boolean shrink) {
        int[] entry = new int[4];
        IntBuffer view = this.hashtable.duplicate();
        view.position(offset);
        view.get(entry);
        if (OffHeapHashMap.isPresent(entry)) {
            this.storageEngine.freeMapping(OffHeapHashMap.readLong(entry, 2));
            view.position(offset);
            view.put(2);
            this.slotRemoved(offset);
            if (shrink) {
                this.shrink();
            }
        } else {
            throw new AssertionError();
        }
    }

    protected V getAtTableOffset(int offset) {
        int[] entry = new int[4];
        IntBuffer view = this.hashtable.duplicate();
        view.position(offset);
        view.get(entry);
        if (OffHeapHashMap.isPresent(entry)) {
            return this.storageEngine.readValue(OffHeapHashMap.readLong(entry, 2));
        }
        throw new AssertionError();
    }

    protected Map.Entry<K, V> getEntryAtTableOffset(int offset) {
        int[] entry = new int[4];
        IntBuffer view = this.hashtable.duplicate();
        view.position(offset);
        view.get(entry);
        if (OffHeapHashMap.isPresent(entry)) {
            return new DirectEntry(entry[1], OffHeapHashMap.readLong(entry, 2));
        }
        throw new AssertionError();
    }

    public int getSlotForHashAndEncoding(int hash, long encoding, long mask) {
        IntBuffer view = (IntBuffer)this.hashtable.duplicate().position(this.indexFor(OffHeapHashMap.spread(hash)));
        int[] entry = new int[4];
        int limit = this.reprobeLimit();
        for (int i = 0; i < limit; ++i) {
            if (!view.hasRemaining()) {
                view.rewind();
            }
            view.get(entry);
            if (OffHeapHashMap.isTerminating(entry)) {
                throw new AssertionError();
            }
            if (!OffHeapHashMap.isPresent(entry) || hash != entry[1] || (encoding & mask) != (OffHeapHashMap.readLong(entry, 2) & mask)) continue;
            return view.position() - 4;
        }
        throw new AssertionError();
    }

    private void slotRemoved(int position) {
        ++this.modCount;
        ++this.removedSlots;
        --this.size;
        this.removed(position);
    }

    private void slotAdded(int position) {
        ++this.modCount;
        ++this.putCount;
        ++this.size;
        this.added(position);
    }

    protected void added(int position) {
    }

    protected void hit(int position) {
    }

    protected void removed(int position) {
    }

    protected void tableExpansionFailure(int start, int length) {
        StringBuilder sb = new StringBuilder("Failed to expand table.\n");
        sb.append("Current Table Size (slots) : ").append(this.getTableCapacity()).append('\n');
        sb.append("Resize Will Require        : ").append(DebuggingUtils.toBase2SuffixedString(this.getTableCapacity() * 4L * 4L * 2L)).append("B\n");
        sb.append("Table Buffer Source        : ").append(this.tableSource);
        throw new OutOfMemoryError(sb.toString());
    }

    protected void storageEngineFailure(int activeIndex, Object failure) {
        StringBuilder sb = new StringBuilder("Storage engine failed to store: ");
        sb.append(failure).append('\n');
        sb.append("StorageEngine: ").append(this.storageEngine);
        throw new OutOfMemoryError(sb.toString());
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getTableCapacity() {
        IntBuffer table = this.hashtable;
        return table == null ? 0L : (long)(table.capacity() / 4);
    }

    @Override
    public long getUsedSlotCount() {
        return this.getSize();
    }

    @Override
    public long getRemovedSlotCount() {
        return this.removedSlots;
    }

    @Override
    public int getReprobeLength() {
        return this.reprobeLimit();
    }

    @Override
    public long getHitCount() {
        return this.hitCount.get();
    }

    @Override
    public long getMissCount() {
        return this.missCount.get();
    }

    @Override
    public long getPutCount() {
        return this.putCount;
    }

    @Override
    public long getAverageLatency() {
        throw new UnsupportedOperationException("This map does not support latency monitoring.");
    }

    @Override
    public long getMaximumLatency() {
        throw new UnsupportedOperationException("This map does not support latency monitoring.");
    }

    @Override
    public long getMinimumLatency() {
        throw new UnsupportedOperationException("This map does not support latency monitoring.");
    }

    @Override
    public long getSigmaLatency() {
        throw new UnsupportedOperationException("This map does not support latency monitoring.");
    }

    @Override
    public long getLatencySampleSize() {
        throw new UnsupportedOperationException("This map does not support latency monitoring.");
    }

    @Override
    public long getAllocatedMemory() {
        return this.getDataAllocatedMemory() + this.getTableCapacity() * 4L * 4L;
    }

    @Override
    public long getOccupiedMemory() {
        return this.getDataOccupiedMemory() + this.getUsedSlotCount() * 4L * 4L;
    }

    @Override
    public long getDataAllocatedMemory() {
        return this.storageEngine.getAllocatedMemory();
    }

    @Override
    public long getDataOccupiedMemory() {
        return this.storageEngine.getOccupiedMemory();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DirectEntry
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        DirectEntry(int hashCode, long encoding) {
            this.key = OffHeapHashMap.this.storageEngine.readKey(encoding, hashCode);
            this.value = OffHeapHashMap.this.storageEngine.readValue(encoding);
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                return this.key.equals(e.getKey()) && this.value.equals(e.getValue());
            }
            return false;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        protected Map.Entry<K, V> create(int hash, long encoding) {
            return new DirectEntry(hash, encoding);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class KeyIterator
    extends HashIterator<K> {
        KeyIterator() {
        }

        @Override
        protected K create(int hash, long encoding) {
            return OffHeapHashMap.this.storageEngine.readKey(encoding, hash);
        }
    }

    static class PendingPage {
        final Page tablePage;
        final int reprobe;

        PendingPage(Page tablePage, int reprobe) {
            this.tablePage = tablePage;
            this.reprobe = reprobe;
        }
    }

    static class RetiredTable {
        final IntBuffer table;
        final int reprobe;

        RetiredTable(IntBuffer table, int reprobe) {
            this.table = table;
            this.reprobe = reprobe;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class HashIterator<T>
    implements Iterator<T> {
        final List<RetiredTable> retiredTables = new ArrayList<RetiredTable>(1);
        final int expectedModCount;
        IntBuffer table;
        IntBuffer tableView;
        T next = null;

        HashIterator() {
            OffHeapHashMap.this.hasUsedIterators = true;
            this.table = OffHeapHashMap.this.hashtable;
            this.tableView = (IntBuffer)this.table.asReadOnlyBuffer().clear();
            this.expectedModCount = OffHeapHashMap.this.modCount;
            if (OffHeapHashMap.this.size > 0) {
                int[] entry = new int[4];
                while (this.tableView.hasRemaining()) {
                    this.tableView.get(entry);
                    if (!OffHeapHashMap.isPresent(entry)) continue;
                    this.next = this.create(entry[1], OffHeapHashMap.readLong(entry, 2));
                    break;
                }
            }
        }

        protected abstract T create(int var1, long var2);

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            this.checkForConcurrentModification();
            T e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            if (OffHeapHashMap.this.hashtable != this.table) {
                PendingPage pending = (PendingPage)OffHeapHashMap.this.pendingTableFrees.get(this.table);
                assert (pending != null);
                this.retiredTables.add(new RetiredTable((IntBuffer)this.tableView.flip(), pending.reprobe));
                this.table = OffHeapHashMap.this.hashtable;
                this.tableView = (IntBuffer)this.table.asReadOnlyBuffer().clear();
            }
            int[] entry = new int[4];
            this.next = null;
            while (this.tableView.hasRemaining()) {
                this.tableView.get(entry);
                if (!OffHeapHashMap.isPresent(entry) || this.hasVisited(entry)) continue;
                this.next = this.create(entry[1], OffHeapHashMap.readLong(entry, 2));
                break;
            }
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected void checkForConcurrentModification() {
            if (OffHeapHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        private boolean hasVisited(int[] check) {
            for (RetiredTable retired : this.retiredTables) {
                if (!OffHeapHashMap.visited(check, retired)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean contains(Object o) {
            return OffHeapHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return OffHeapHashMap.this.remove(o) != null;
        }

        @Override
        public int size() {
            return OffHeapHashMap.this.size();
        }

        @Override
        public void clear() {
            OffHeapHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object value = OffHeapHashMap.this.get(e.getKey());
            return value != null && value.equals(e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            return OffHeapHashMap.this.removeMapping(o);
        }

        @Override
        public int size() {
            return OffHeapHashMap.this.size;
        }

        @Override
        public void clear() {
            OffHeapHashMap.this.clear();
        }
    }
}

