/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.inject;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dozer.MappingException;
import org.dozer.inject.BeanRegistry;
import org.dozer.inject.Inject;
import org.dozer.util.ReflectionUtils;

public class DozerBeanContainer
implements BeanRegistry {
    private Map<Class<?>, Object[]> beans = new ConcurrentHashMap();

    @Override
    public void register(Class<?> type) {
        this.beans.put(type, new Object[1]);
    }

    @Override
    public <T> T getBean(Class<T> type) {
        Collection<T> result = this.getBeans(type);
        if (result.isEmpty()) {
            throw new IllegalStateException("Bean is not registered : " + type.getName());
        }
        if (result.size() > 1) {
            throw new IllegalStateException("More than one bean found of type : " + type.getName());
        }
        return result.iterator().next();
    }

    @Override
    public <T> Collection<T> getBeans(Class<T> type) {
        HashSet<Object> result = new HashSet<Object>();
        for (Map.Entry<Class<?>, Object[]> entry : this.beans.entrySet()) {
            if (!type.isAssignableFrom(entry.getKey())) continue;
            Object[] value = entry.getValue();
            if (value[0] == null) {
                value[0] = this.wireBean(entry.getKey());
            }
            result.add(value[0]);
        }
        return result;
    }

    private <T> T wireBean(Class<T> type) {
        Field[] destFields;
        T bean = ReflectionUtils.newInstance(type);
        for (Field field : destFields = type.getDeclaredFields()) {
            Inject inject = field.getAnnotation(Inject.class);
            if (inject == null) continue;
            Class<?> fieldType = field.getType();
            try {
                if (field.get(bean) != null) continue;
                Object dependency = this.wireBean(fieldType);
                field.set(bean, dependency);
            }
            catch (IllegalAccessException e) {
                throw new MappingException("Field annotated with @Inject is not accessible : " + field.getName(), e);
            }
        }
        Object[] instance = this.beans.get(type);
        if (instance == null) {
            instance = new Object[1];
            this.beans.put(type, instance);
        }
        instance[0] = bean;
        return bean;
    }
}

