/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.dozer.cache.Cache;
import org.dozer.cache.CacheManager;
import org.dozer.cache.DozerCache;
import org.dozer.util.MappingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DozerCacheManager
implements CacheManager {
    private final Logger log = LoggerFactory.getLogger(DozerCacheManager.class);
    private final Map<String, Cache> cachesMap = new HashMap<String, Cache>();

    @Override
    public Collection<Cache> getCaches() {
        return new HashSet<Cache>(this.cachesMap.values());
    }

    @Override
    public Cache getCache(String name) {
        Cache cache = this.cachesMap.get(name);
        if (cache == null) {
            MappingUtils.throwMappingException("Unable to find cache with name: " + name);
        }
        return cache;
    }

    @Override
    public void addCache(String name, int maxElementsInMemory) {
        this.addCache(new DozerCache(name, maxElementsInMemory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCache(Cache cache) {
        Map<String, Cache> map = this.cachesMap;
        synchronized (map) {
            String name = cache.getName();
            if (this.cacheExists(name)) {
                MappingUtils.throwMappingException("Cache already exists with name: " + name);
            }
            this.cachesMap.put(name, cache);
        }
    }

    @Override
    public Collection<String> getCacheNames() {
        HashSet<String> results = new HashSet<String>();
        for (Map.Entry<String, Cache> entry : this.cachesMap.entrySet()) {
            results.add(entry.getKey());
        }
        return results;
    }

    @Override
    public void clearAllEntries() {
        for (Cache cache : this.cachesMap.values()) {
            cache.clear();
        }
    }

    @Override
    public boolean cacheExists(String name) {
        return this.cachesMap.containsKey(name);
    }

    public void logCaches() {
        this.log.info(this.getCaches().toString());
    }
}

