/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.converters;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.apache.commons.beanutils.converters.BigIntegerConverter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.ByteConverter;
import org.apache.commons.beanutils.converters.CharacterConverter;
import org.apache.commons.beanutils.converters.ClassConverter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.ShortConverter;
import org.apache.commons.lang3.ClassUtils;
import org.dozer.converters.CalendarConverter;
import org.dozer.converters.ConversionException;
import org.dozer.converters.DateConverter;
import org.dozer.converters.DateFormatContainer;
import org.dozer.converters.EnumConverter;
import org.dozer.converters.IntegerConverter;
import org.dozer.converters.LongConverter;
import org.dozer.converters.StringConstructorConverter;
import org.dozer.converters.StringConverter;
import org.dozer.converters.XMLGregorianCalendarConverter;
import org.dozer.util.MappingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitiveOrWrapperConverter {
    private static final Map<Class, Converter> CONVERTER_MAP = new HashMap<Class, Converter>();

    public Object convert(Object srcFieldValue, Class destFieldClass, DateFormatContainer dateFormatContainer) {
        if (srcFieldValue == null || destFieldClass == null || srcFieldValue.equals("") && !destFieldClass.equals(String.class)) {
            return null;
        }
        Converter converter = this.getPrimitiveOrWrapperConverter(destFieldClass, dateFormatContainer);
        try {
            return converter.convert(destFieldClass, srcFieldValue);
        }
        catch (org.apache.commons.beanutils.ConversionException e) {
            throw new ConversionException(e);
        }
    }

    private Converter getPrimitiveOrWrapperConverter(Class destClass, DateFormatContainer dateFormatContainer) {
        if (String.class.equals((Object)destClass)) {
            return new StringConverter(dateFormatContainer);
        }
        Converter result = CONVERTER_MAP.get(ClassUtils.primitiveToWrapper((Class)destClass));
        if (result == null) {
            if (Date.class.isAssignableFrom(destClass)) {
                result = new DateConverter(dateFormatContainer.getDateFormat());
            } else if (Calendar.class.isAssignableFrom(destClass)) {
                result = new CalendarConverter(dateFormatContainer.getDateFormat());
            } else if (XMLGregorianCalendar.class.isAssignableFrom(destClass)) {
                result = new XMLGregorianCalendarConverter(dateFormatContainer.getDateFormat());
            } else if (MappingUtils.isEnumType(destClass)) {
                result = new EnumConverter();
            }
        }
        return result == null ? new StringConstructorConverter(dateFormatContainer) : result;
    }

    public boolean accepts(Class<?> aClass) {
        return aClass.isPrimitive() || Number.class.isAssignableFrom(aClass) || String.class.equals(aClass) || Character.class.equals(aClass) || Boolean.class.equals(aClass) || Date.class.isAssignableFrom(aClass) || Calendar.class.isAssignableFrom(aClass);
    }

    static {
        CONVERTER_MAP.put(Integer.class, new IntegerConverter());
        CONVERTER_MAP.put(Double.class, (Converter)new DoubleConverter());
        CONVERTER_MAP.put(Short.class, (Converter)new ShortConverter());
        CONVERTER_MAP.put(Character.class, (Converter)new CharacterConverter());
        CONVERTER_MAP.put(Long.class, new LongConverter());
        CONVERTER_MAP.put(Boolean.class, (Converter)new BooleanConverter());
        CONVERTER_MAP.put(Byte.class, (Converter)new ByteConverter());
        CONVERTER_MAP.put(Float.class, (Converter)new FloatConverter());
        CONVERTER_MAP.put(BigDecimal.class, (Converter)new BigDecimalConverter());
        CONVERTER_MAP.put(BigInteger.class, (Converter)new BigIntegerConverter());
        CONVERTER_MAP.put(Class.class, (Converter)new ClassConverter());
    }
}

