/*
 * Decompiled with CFR 0.152.
 */
package org.dozer;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.dozer.BeanFactory;
import org.dozer.CustomConverter;
import org.dozer.CustomFieldMapper;
import org.dozer.DozerEventListener;
import org.dozer.DozerInitializer;
import org.dozer.Mapper;
import org.dozer.MappingException;
import org.dozer.MappingProcessor;
import org.dozer.cache.CacheManager;
import org.dozer.cache.DozerCacheManager;
import org.dozer.cache.DozerCacheType;
import org.dozer.classmap.ClassMappings;
import org.dozer.classmap.Configuration;
import org.dozer.classmap.MappingFileData;
import org.dozer.config.GlobalSettings;
import org.dozer.event.DozerEventManager;
import org.dozer.factory.DestBeanCreator;
import org.dozer.loader.CustomMappingsLoader;
import org.dozer.loader.LoadMappingsResult;
import org.dozer.loader.api.BeanMappingBuilder;
import org.dozer.stats.GlobalStatistics;
import org.dozer.stats.StatisticType;
import org.dozer.stats.StatisticsInterceptor;
import org.dozer.stats.StatisticsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DozerBeanMapper
implements Mapper {
    private static final Logger log = LoggerFactory.getLogger(DozerBeanMapper.class);
    private static final StatisticsManager statsMgr = GlobalStatistics.getInstance().getStatsMgr();
    private final AtomicBoolean initializing = new AtomicBoolean(false);
    private final CountDownLatch ready = new CountDownLatch(1);
    private final List<String> mappingFiles = new ArrayList<String>();
    private final List<CustomConverter> customConverters = new ArrayList<CustomConverter>();
    private final List<MappingFileData> builderMappings = new ArrayList<MappingFileData>();
    private final Map<String, CustomConverter> customConvertersWithId = new HashMap<String, CustomConverter>();
    private List<? extends DozerEventListener> eventListeners = new ArrayList<DozerEventListener>();
    private CustomFieldMapper customFieldMapper;
    private ClassMappings customMappings;
    private Configuration globalConfiguration;
    private final CacheManager cacheManager = new DozerCacheManager();
    private DozerEventManager eventManager;

    public DozerBeanMapper() {
        this(Collections.emptyList());
    }

    public DozerBeanMapper(List<String> mappingFiles) {
        this.mappingFiles.addAll(mappingFiles);
        this.init();
    }

    @Override
    public void map(Object source, Object destination, String mapId) throws MappingException {
        this.getMappingProcessor().map(source, destination, mapId);
    }

    @Override
    public <T> T map(Object source, Class<T> destinationClass, String mapId) throws MappingException {
        return this.getMappingProcessor().map(source, destinationClass, mapId);
    }

    @Override
    public <T> T map(Object source, Class<T> destinationClass) throws MappingException {
        return this.getMappingProcessor().map(source, destinationClass);
    }

    @Override
    public void map(Object source, Object destination) throws MappingException {
        this.getMappingProcessor().map(source, destination);
    }

    public List<String> getMappingFiles() {
        return Collections.unmodifiableList(this.mappingFiles);
    }

    public void setMappingFiles(List<String> mappingFileUrls) {
        this.checkIfInitialized();
        this.mappingFiles.clear();
        this.mappingFiles.addAll(mappingFileUrls);
    }

    public void setFactories(Map<String, BeanFactory> factories) {
        this.checkIfInitialized();
        DestBeanCreator.setStoredFactories(factories);
    }

    public void setCustomConverters(List<CustomConverter> customConverters) {
        this.checkIfInitialized();
        this.customConverters.clear();
        this.customConverters.addAll(customConverters);
    }

    public List<CustomConverter> getCustomConverters() {
        return Collections.unmodifiableList(this.customConverters);
    }

    public Map<String, CustomConverter> getCustomConvertersWithId() {
        return Collections.unmodifiableMap(this.customConvertersWithId);
    }

    private void init() {
        DozerInitializer.getInstance().init();
        log.info("Initializing a new instance of dozer bean mapper.");
        GlobalSettings globalSettings = GlobalSettings.getInstance();
        this.cacheManager.addCache(DozerCacheType.CONVERTER_BY_DEST_TYPE.name(), globalSettings.getConverterByDestTypeCacheMaxSize());
        this.cacheManager.addCache(DozerCacheType.SUPER_TYPE_CHECK.name(), globalSettings.getSuperTypesCacheMaxSize());
        statsMgr.increment(StatisticType.MAPPER_INSTANCES_COUNT);
    }

    public void destroy() {
        DozerInitializer.getInstance().destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Mapper getMappingProcessor() {
        if (this.initializing.compareAndSet(false, true)) {
            try {
                this.loadCustomMappings();
                this.eventManager = new DozerEventManager(this.eventListeners);
            }
            finally {
                this.ready.countDown();
            }
        }
        try {
            this.ready.await();
        }
        catch (InterruptedException e) {
            log.error("Thread interrupted: ", (Throwable)e);
        }
        Mapper processor = new MappingProcessor(this.customMappings, this.globalConfiguration, this.cacheManager, statsMgr, this.customConverters, this.eventManager, this.getCustomFieldMapper(), this.customConvertersWithId);
        if (statsMgr.isStatisticsEnabled()) {
            processor = (Mapper)Proxy.newProxyInstance(processor.getClass().getClassLoader(), processor.getClass().getInterfaces(), (InvocationHandler)new StatisticsInterceptor(processor, statsMgr));
        }
        return processor;
    }

    void loadCustomMappings() {
        CustomMappingsLoader customMappingsLoader = new CustomMappingsLoader();
        LoadMappingsResult loadMappingsResult = customMappingsLoader.load(this.mappingFiles, this.builderMappings);
        this.customMappings = loadMappingsResult.getCustomMappings();
        this.globalConfiguration = loadMappingsResult.getGlobalConfiguration();
    }

    public void setMappings(List<? extends BeanMappingBuilder> mappingBuilder) {
        for (BeanMappingBuilder beanMappingBuilder : mappingBuilder) {
            this.addMapping(beanMappingBuilder);
        }
    }

    public void addMapping(BeanMappingBuilder mappingBuilder) {
        this.checkIfInitialized();
        MappingFileData mappingFileData = mappingBuilder.build();
        this.builderMappings.add(mappingFileData);
    }

    public List<? extends DozerEventListener> getEventListeners() {
        return Collections.unmodifiableList(this.eventListeners);
    }

    public void setEventListeners(List<? extends DozerEventListener> eventListeners) {
        this.checkIfInitialized();
        this.eventListeners = eventListeners;
    }

    public CustomFieldMapper getCustomFieldMapper() {
        return this.customFieldMapper;
    }

    public void setCustomFieldMapper(CustomFieldMapper customFieldMapper) {
        this.checkIfInitialized();
        this.customFieldMapper = customFieldMapper;
    }

    public void setCustomConvertersWithId(Map<String, CustomConverter> customConvertersWithId) {
        this.checkIfInitialized();
        this.customConvertersWithId.clear();
        this.customConvertersWithId.putAll(customConvertersWithId);
    }

    private void checkIfInitialized() {
        if (this.ready.getCount() == 0L) {
            throw new MappingException("Dozer Bean Mapper is already initialized! Modify settings before calling map()");
        }
    }
}

