/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.loader;

import java.util.HashSet;
import java.util.List;
import org.dozer.classmap.ClassMap;
import org.dozer.classmap.ClassMappings;
import org.dozer.classmap.Configuration;
import org.dozer.classmap.MappingDirection;
import org.dozer.fieldmap.ExcludeFieldMap;
import org.dozer.fieldmap.FieldMap;
import org.dozer.fieldmap.GenericFieldMap;
import org.dozer.fieldmap.MapFieldMap;
import org.dozer.util.MappingUtils;
import org.dozer.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MappingsParser {
    private static final MappingsParser INSTANCE = new MappingsParser();

    public static MappingsParser getInstance() {
        return INSTANCE;
    }

    private MappingsParser() {
    }

    public ClassMappings processMappings(List<ClassMap> classMaps, Configuration globalConfiguration) {
        if (globalConfiguration == null) {
            throw new IllegalArgumentException("Global configuration parameter cannot be null");
        }
        ClassMappings result = new ClassMappings();
        if (classMaps == null || classMaps.size() == 0) {
            return result;
        }
        HashSet<String> mapIds = new HashSet<String>();
        for (ClassMap classMap : classMaps) {
            classMap.setGlobalConfiguration(globalConfiguration);
            ReflectionUtils.findPropertyDescriptor(classMap.getSrcClassToMap(), "", null);
            ReflectionUtils.findPropertyDescriptor(classMap.getDestClassToMap(), "", null);
            if (!MappingUtils.isBlankOrNull(classMap.getMapId())) {
                if (mapIds.contains(classMap.getMapId())) {
                    throw new IllegalArgumentException("Duplicate Map Id's Found. Map Id: " + classMap.getMapId());
                }
                mapIds.add(classMap.getMapId());
            }
            result.add(classMap.getSrcClassToMap(), classMap.getDestClassToMap(), classMap.getMapId(), classMap);
            ClassMap classMapPrime = new ClassMap(globalConfiguration);
            MappingUtils.reverseFields(classMap, classMapPrime);
            if (classMap.getFieldMaps() != null) {
                FieldMap fieldMapPrime;
                Object[] fms = classMap.getFieldMaps().toArray();
                if (!MappingDirection.ONE_WAY.equals(classMap.getType())) {
                    for (Object fm1 : fms) {
                        FieldMap fieldMap = (FieldMap)fm1;
                        fieldMap.validate();
                        if (!(fieldMap instanceof ExcludeFieldMap) && (MappingUtils.isSupportedMap(classMap.getDestClassToMap()) && !MappingUtils.isSupportedMap(classMap.getSrcClassToMap()) || MappingUtils.isSupportedMap(classMap.getSrcClassToMap()) && !MappingUtils.isSupportedMap(classMap.getDestClassToMap()) || MappingUtils.isSupportedMap(fieldMap.getDestFieldType(classMap.getDestClassToMap())) && !MappingUtils.isSupportedMap(fieldMap.getSrcFieldType(classMap.getSrcClassToMap())) || MappingUtils.isSupportedMap(fieldMap.getSrcFieldType(classMap.getSrcClassToMap())) && !MappingUtils.isSupportedMap(fieldMap.getDestFieldType(classMap.getDestClassToMap())))) {
                            MapFieldMap fm = new MapFieldMap(fieldMap);
                            classMap.removeFieldMapping(fieldMap);
                            classMap.addFieldMapping(fm);
                            fieldMap = fm;
                        }
                        if (!MappingDirection.ONE_WAY.equals(fieldMap.getType()) || fieldMap instanceof ExcludeFieldMap) {
                            fieldMapPrime = (FieldMap)fieldMap.clone();
                            fieldMapPrime.setClassMap(classMapPrime);
                            if (fieldMapPrime instanceof ExcludeFieldMap && MappingDirection.ONE_WAY.equals(fieldMap.getType())) {
                                fieldMapPrime = new GenericFieldMap(classMapPrime);
                            }
                            MappingUtils.reverseFields(fieldMap, fieldMapPrime);
                            if (!(fieldMap instanceof ExcludeFieldMap)) {
                                MappingUtils.applyGlobalCopyByReference(globalConfiguration, fieldMap, classMap);
                            }
                            if (!(fieldMapPrime instanceof ExcludeFieldMap)) {
                                MappingUtils.applyGlobalCopyByReference(globalConfiguration, fieldMapPrime, classMapPrime);
                            }
                        } else {
                            fieldMapPrime = new ExcludeFieldMap(classMapPrime);
                            MappingUtils.reverseFields(fieldMap, fieldMapPrime);
                        }
                        classMapPrime.addFieldMapping(fieldMapPrime);
                    }
                } else {
                    for (Object fm : fms) {
                        FieldMap oneWayFieldMap = (FieldMap)fm;
                        oneWayFieldMap.validate();
                        MappingUtils.applyGlobalCopyByReference(globalConfiguration, oneWayFieldMap, classMap);
                        if (!MappingDirection.ONE_WAY.equals(oneWayFieldMap.getType())) continue;
                        fieldMapPrime = new ExcludeFieldMap(classMapPrime);
                        MappingUtils.reverseFields(oneWayFieldMap, fieldMapPrime);
                        classMapPrime.addFieldMapping(fieldMapPrime);
                    }
                }
            }
            if (MappingDirection.ONE_WAY.equals(classMap.getType())) continue;
            result.add(classMap.getDestClassToMap(), classMap.getSrcClassToMap(), classMap.getMapId(), classMapPrime);
        }
        return result;
    }
}

