/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.loader.xml;

import java.io.InputStream;
import org.dozer.util.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DozerResolver
implements EntityResolver {
    private static final Logger log = LoggerFactory.getLogger(DozerResolver.class);

    public InputSource resolveEntity(String publicId, String systemId) {
        log.debug("Trying to resolve XML entity with public ID [{}] and system ID [{}]", (Object)publicId, (Object)systemId);
        if (systemId != null && systemId.indexOf("beanmapping.xsd") > systemId.lastIndexOf("/")) {
            String fileName = systemId.substring(systemId.indexOf("beanmapping.xsd"));
            log.debug("Trying to locate [{}] in classpath", (Object)fileName);
            try {
                ResourceLoader resourceLoader = new ResourceLoader();
                InputStream stream = resourceLoader.getResource(fileName).openStream();
                InputSource source = new InputSource(stream);
                source.setPublicId(publicId);
                source.setSystemId(systemId);
                log.debug("Found beanmapping XML Schema [{}] in classpath", (Object)systemId);
                return source;
            }
            catch (Exception ex) {
                log.error("Could not resolve beanmapping XML Schema [" + systemId + "]: not found in classpath", (Throwable)ex);
            }
        }
        return null;
    }
}

