/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.loader.xml;

import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dozer.util.ResourceLoader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DozerResolver
implements EntityResolver {
    private static final Log log = LogFactory.getLog(DozerResolver.class);

    public InputSource resolveEntity(String publicId, String systemId) {
        log.debug((Object)("Trying to resolve XML entity with public ID [" + publicId + "] and system ID [" + systemId + "]"));
        if (systemId != null && systemId.indexOf("beanmapping.xsd") > systemId.lastIndexOf("/")) {
            String fileName = systemId.substring(systemId.indexOf("beanmapping.xsd"));
            log.debug((Object)("Trying to locate [" + fileName + "] in classpath"));
            try {
                ResourceLoader resourceLoader = new ResourceLoader();
                InputStream stream = resourceLoader.getResource(fileName).openStream();
                InputSource source = new InputSource(stream);
                source.setPublicId(publicId);
                source.setSystemId(systemId);
                log.debug((Object)("Found beanmapping XML Schema [" + systemId + "] in classpath"));
                return source;
            }
            catch (Exception ex) {
                log.error((Object)("Could not resolve beansmapping XML Schema [" + systemId + "]: not found in classpath"), (Throwable)ex);
            }
        }
        return null;
    }
}

