/*
 * Decompiled with CFR 0.152.
 */
package org.dozer;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dozer.BeanFactory;
import org.dozer.CustomConverter;
import org.dozer.CustomFieldMapper;
import org.dozer.DozerEventListener;
import org.dozer.DozerInitializer;
import org.dozer.Mapper;
import org.dozer.MappingException;
import org.dozer.MappingProcessor;
import org.dozer.cache.CacheManager;
import org.dozer.cache.DozerCacheManager;
import org.dozer.cache.DozerCacheType;
import org.dozer.classmap.ClassMappings;
import org.dozer.classmap.Configuration;
import org.dozer.config.GlobalSettings;
import org.dozer.factory.DestBeanCreator;
import org.dozer.loader.CustomMappingsLoader;
import org.dozer.loader.LoadMappingsResult;
import org.dozer.stats.GlobalStatistics;
import org.dozer.stats.StatisticType;
import org.dozer.stats.StatisticsInterceptor;
import org.dozer.stats.StatisticsManager;
import org.dozer.util.InitLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DozerBeanMapper
implements Mapper {
    private static final Log log = LogFactory.getLog(DozerBeanMapper.class);
    private static final StatisticsManager statsMgr = GlobalStatistics.getInstance().getStatsMgr();
    private List<String> mappingFiles;
    private List<CustomConverter> customConverters;
    private List<DozerEventListener> eventListeners;
    private CustomFieldMapper customFieldMapper;
    private Map<String, CustomConverter> customConvertersWithId;
    private ClassMappings customMappings;
    private Configuration globalConfiguration;
    private final CacheManager cacheManager = new DozerCacheManager();

    public DozerBeanMapper() {
        this(null);
    }

    public DozerBeanMapper(List<String> mappingFiles) {
        this.mappingFiles = mappingFiles;
        this.init();
    }

    @Override
    public void map(Object source, Object destination, String mapId) throws MappingException {
        this.getMappingProcessor().map(source, destination, mapId);
    }

    @Override
    public <T> T map(Object source, Class<T> destinationClass, String mapId) throws MappingException {
        return this.getMappingProcessor().map(source, destinationClass, mapId);
    }

    @Override
    public <T> T map(Object source, Class<T> destinationClass) throws MappingException {
        return this.getMappingProcessor().map(source, destinationClass);
    }

    @Override
    public void map(Object source, Object destination) throws MappingException {
        this.getMappingProcessor().map(source, destination);
    }

    public List<String> getMappingFiles() {
        return this.mappingFiles;
    }

    public void setMappingFiles(List<String> mappingFiles) {
        this.mappingFiles = mappingFiles;
    }

    public void setFactories(Map<String, BeanFactory> factories) {
        DestBeanCreator.setStoredFactories(factories);
    }

    public void setCustomConverters(List<CustomConverter> customConverters) {
        this.customConverters = customConverters;
    }

    private void init() {
        DozerInitializer.getInstance().init();
        InitLogger.log(log, "Initializing a new instance of the dozer bean mapper.");
        this.cacheManager.addCache(DozerCacheType.CONVERTER_BY_DEST_TYPE.name(), GlobalSettings.getInstance().getConverterByDestTypeCacheMaxSize());
        this.cacheManager.addCache(DozerCacheType.SUPER_TYPE_CHECK.name(), GlobalSettings.getInstance().getSuperTypesCacheMaxSize());
        statsMgr.increment(StatisticType.MAPPER_INSTANCES_COUNT);
    }

    public void destroy() {
        DozerInitializer.getInstance().destroy();
    }

    protected Mapper getMappingProcessor() {
        if (this.customMappings == null) {
            this.loadCustomMappings();
        }
        Mapper processor = new MappingProcessor(this.customMappings, this.globalConfiguration, this.cacheManager, statsMgr, this.customConverters, this.getEventListeners(), this.getCustomFieldMapper(), this.customConvertersWithId);
        if (statsMgr.isStatisticsEnabled()) {
            processor = (Mapper)Proxy.newProxyInstance(processor.getClass().getClassLoader(), processor.getClass().getInterfaces(), (InvocationHandler)new StatisticsInterceptor(processor, statsMgr));
        }
        return processor;
    }

    private synchronized void loadCustomMappings() {
        if (this.customMappings == null) {
            CustomMappingsLoader customMappingsLoader = new CustomMappingsLoader();
            LoadMappingsResult loadMappingsResult = customMappingsLoader.load(this.mappingFiles);
            this.customMappings = loadMappingsResult.getCustomMappings();
            this.globalConfiguration = loadMappingsResult.getGlobalConfiguration();
        }
    }

    public List<DozerEventListener> getEventListeners() {
        return this.eventListeners;
    }

    public void setEventListeners(List<DozerEventListener> eventListeners) {
        this.eventListeners = eventListeners;
    }

    public CustomFieldMapper getCustomFieldMapper() {
        return this.customFieldMapper;
    }

    public void setCustomFieldMapper(CustomFieldMapper customFieldMapper) {
        this.customFieldMapper = customFieldMapper;
    }

    public Map<String, CustomConverter> getCustomConvertersWithId() {
        return this.customConvertersWithId;
    }

    public void setCustomConvertersWithId(Map<String, CustomConverter> customConvertersWithId) {
        this.customConvertersWithId = customConvertersWithId;
    }
}

