/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.swingbox.util;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.fit.cssbox.layout.TextBox;
import org.fit.cssbox.swingbox.SwingBoxDocument;
import org.fit.cssbox.swingbox.util.Anchor;

public class MouseController
extends MouseAdapter {
    private static final Cursor defaultCursor = Cursor.getPredefinedCursor(0);
    private static final Cursor textCursor = Cursor.getPredefinedCursor(2);
    private Element prevElem;
    private Anchor prevAnchor;

    @Override
    public void mouseClicked(MouseEvent e) {
        JEditorPane editor = (JEditorPane)e.getSource();
        if (!editor.isEditable() && SwingUtilities.isLeftMouseButton(e)) {
            Element el;
            AttributeSet attr;
            Anchor anchor;
            Position.Bias[] bias = new Position.Bias[1];
            Point pt = new Point(e.getX(), e.getY());
            int pos = editor.getUI().viewToModel(editor, pt, bias);
            if (bias[0] == Position.Bias.Backward && pos > 0) {
                --pos;
            }
            if (pos >= 0 && (anchor = (Anchor)(attr = (el = ((SwingBoxDocument)editor.getDocument()).getCharacterElement(pos)).getAttributes()).getAttribute("attribute_anchor_reference")) != null && anchor.isActive()) {
                this.createHyperLinkEvent(editor, el, anchor, HyperlinkEvent.EventType.ACTIVATED);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        JEditorPane editor = (JEditorPane)e.getSource();
        if (!editor.isEditable()) {
            Position.Bias[] bias = new Position.Bias[1];
            Point pt = new Point(e.getX(), e.getY());
            int pos = editor.getUI().viewToModel(editor, pt, bias);
            if (bias[0] == Position.Bias.Backward && pos > 0) {
                --pos;
            }
            if (pos >= 0 && editor.getDocument() instanceof StyledDocument) {
                Element elem = ((StyledDocument)editor.getDocument()).getCharacterElement(pos);
                Object bb = elem.getAttributes().getAttribute("attribute_box_reference");
                Anchor anchor = (Anchor)elem.getAttributes().getAttribute("attribute_anchor_reference");
                if (elem != this.prevElem) {
                    this.prevElem = elem;
                    if (!anchor.isActive()) {
                        if (bb != null && bb instanceof TextBox) {
                            this.setCursor(editor, textCursor);
                        } else {
                            this.setCursor(editor, defaultCursor);
                        }
                    }
                }
                if (anchor != this.prevAnchor) {
                    if (this.prevAnchor == null) {
                        if (anchor.isActive()) {
                            this.createHyperLinkEvent(editor, elem, anchor, HyperlinkEvent.EventType.ENTERED);
                        }
                        this.prevAnchor = anchor;
                    } else if (!this.prevAnchor.equalProperties(anchor.getProperties())) {
                        if (this.prevAnchor.isActive()) {
                            this.createHyperLinkEvent(editor, this.prevElem, this.prevAnchor, HyperlinkEvent.EventType.EXITED);
                        }
                        if (anchor.isActive()) {
                            this.createHyperLinkEvent(editor, elem, anchor, HyperlinkEvent.EventType.ENTERED);
                        }
                        this.prevAnchor = anchor;
                    }
                }
            } else {
                this.prevElem = null;
                if (this.prevAnchor != null && this.prevAnchor.isActive()) {
                    this.createHyperLinkEvent(editor, this.prevElem, this.prevAnchor, HyperlinkEvent.EventType.EXITED);
                    this.prevAnchor = null;
                }
                this.setCursor(editor, defaultCursor);
            }
        }
    }

    private void createHyperLinkEvent(JEditorPane editor, Element elem, Anchor anchor, HyperlinkEvent.EventType type) {
        URL url;
        String href = anchor.getProperties().get("a_href");
        String target = anchor.getProperties().get("a_target");
        URL base = (URL)editor.getDocument().getProperty("stream");
        try {
            url = new URL(base, href);
        }
        catch (MalformedURLException ignored) {
            url = null;
        }
        HTMLFrameHyperlinkEvent linkEvent = new HTMLFrameHyperlinkEvent((Object)editor, type, url, href, elem, target);
        editor.fireHyperlinkUpdate(linkEvent);
    }

    protected void setCursor(JEditorPane editor, Cursor cursor) {
        if (editor.getCursor() != cursor) {
            editor.setCursor(cursor);
        }
    }
}

