/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.swingbox.util;

import java.awt.Dimension;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import org.fit.cssbox.io.DocumentSource;
import org.fit.cssbox.layout.BlockBox;
import org.fit.cssbox.layout.BlockReplacedBox;
import org.fit.cssbox.layout.BlockTableBox;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.InlineBlockReplacedBox;
import org.fit.cssbox.layout.InlineBox;
import org.fit.cssbox.layout.ListItemBox;
import org.fit.cssbox.layout.ReplacedBox;
import org.fit.cssbox.layout.TableBodyBox;
import org.fit.cssbox.layout.TableBox;
import org.fit.cssbox.layout.TableCaptionBox;
import org.fit.cssbox.layout.TableCellBox;
import org.fit.cssbox.layout.TableColumn;
import org.fit.cssbox.layout.TableColumnGroup;
import org.fit.cssbox.layout.TableRowBox;
import org.fit.cssbox.layout.TextBox;
import org.fit.cssbox.layout.Viewport;
import org.fit.cssbox.layout.VisualContext;
import org.fit.cssbox.render.BoxRenderer;
import org.fit.cssbox.swingbox.util.Anchor;
import org.fit.cssbox.swingbox.util.CSSBoxAnalyzer;
import org.w3c.dom.Element;

public class ContentReader
implements BoxRenderer {
    private List<DefaultStyledDocument.ElementSpec> elements;
    private int order;

    public List<DefaultStyledDocument.ElementSpec> read(DocumentSource docSource, CSSBoxAnalyzer cba, Dimension dim) throws IOException {
        Viewport vp;
        if (cba == null) {
            throw new IllegalArgumentException("CSSBoxAnalyzer can not be NULL !!!\nProvide your custom implementation or check instantiation of DefaultAnalyzer object...");
        }
        this.elements = new Vector<DefaultStyledDocument.ElementSpec>();
        this.elements.add(new DefaultStyledDocument.ElementSpec(SimpleAttributeSet.EMPTY, 2));
        this.order = 0;
        try {
            vp = cba.analyze(docSource, dim);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        vp.draw((BoxRenderer)this);
        return this.elements;
    }

    public List<DefaultStyledDocument.ElementSpec> update(Viewport root, Dimension newDimension, CSSBoxAnalyzer cba) throws IOException {
        Viewport vp;
        if (cba == null) {
            throw new IllegalArgumentException("CSSBoxAnalyzer can not be NULL !!!\nProvide your custom implementation or check instantiation of DefaultAnalyzer object...");
        }
        this.elements = new LinkedList<DefaultStyledDocument.ElementSpec>();
        this.elements.add(new DefaultStyledDocument.ElementSpec(SimpleAttributeSet.EMPTY, 2));
        this.order = 0;
        try {
            vp = cba.update(newDimension);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        vp.draw((BoxRenderer)this);
        return this.elements;
    }

    private SimpleAttributeSet buildElement(ElementBox box) {
        if (box instanceof InlineBox) {
            return this.buildInlineBox((InlineBox)box);
        }
        if (box instanceof Viewport) {
            return this.buildViewport((Viewport)box);
        }
        if (box instanceof TableBox) {
            return this.buildTableBox((TableBox)box);
        }
        if (box instanceof TableCaptionBox) {
            return this.buildTableCaptionBox((TableCaptionBox)box);
        }
        if (box instanceof TableBodyBox) {
            return this.buildTableBodyBox((TableBodyBox)box);
        }
        if (box instanceof TableRowBox) {
            return this.buildTableRowBox((TableRowBox)box);
        }
        if (box instanceof TableCellBox) {
            return this.buildTableCellBox((TableCellBox)box);
        }
        if (box instanceof TableColumnGroup) {
            return this.buildTableColumnGroup((TableColumnGroup)box);
        }
        if (box instanceof TableColumn) {
            return this.buildTableColumn((TableColumn)box);
        }
        if (box instanceof BlockTableBox) {
            return this.buildBlockTableBox((BlockTableBox)box);
        }
        if (box instanceof ListItemBox) {
            return this.buildListItemBox((ListItemBox)box);
        }
        if (box instanceof BlockBox) {
            return this.buildBlockBox((BlockBox)box);
        }
        System.err.println("Unknown BOX : " + box.getClass().getName());
        return null;
    }

    private SimpleAttributeSet buildText(TextBox box) {
        VisualContext vc = box.getVisualContext();
        SimpleAttributeSet attr = new SimpleAttributeSet();
        attr.addAttribute("attribute_font_variant", vc.getFontVariant());
        attr.addAttribute("attribute_text_decoration", vc.getTextDecoration());
        attr.addAttribute("attribute_font", vc.getFont());
        attr.addAttribute("attribute_foreground", vc.getColor());
        attr.addAttribute("$ename", "text_box");
        attr.addAttribute("attribute_anchor_reference", new Anchor());
        attr.addAttribute("attribute_box_reference", box);
        return attr;
    }

    private SimpleAttributeSet buildReplacedBox(ReplacedBox box) {
        SimpleAttributeSet attr = new SimpleAttributeSet();
        if (box instanceof BlockReplacedBox) {
            attr.addAttribute("$ename", "block_replaced_box");
        } else if (box instanceof InlineBlockReplacedBox) {
            attr.addAttribute("$ename", "inline_block_replaced_box");
        } else {
            attr.addAttribute("$ename", "inline_replaced_box");
        }
        attr.addAttribute("attribute_box_reference", box);
        attr.addAttribute("attribute_anchor_reference", new Anchor());
        attr.addAttribute("attribute_replaced_content", box.getContentObj());
        return attr;
    }

    private SimpleAttributeSet buildElementBackground(ElementBox box) {
        return this.commonBuild(box, "bg");
    }

    private SimpleAttributeSet buildBlockBox(BlockBox box) {
        return this.commonBuild((ElementBox)box, "block_box");
    }

    private SimpleAttributeSet buildInlineBox(InlineBox box) {
        return this.commonBuild((ElementBox)box, "inline_box");
    }

    private SimpleAttributeSet buildViewport(Viewport box) {
        return this.commonBuild((ElementBox)box, "viewport");
    }

    private SimpleAttributeSet buildBlockTableBox(BlockTableBox box) {
        return this.commonBuild((ElementBox)box, "block_table_box");
    }

    private SimpleAttributeSet buildTableBox(TableBox box) {
        return this.commonBuild((ElementBox)box, "table_box");
    }

    private SimpleAttributeSet buildTableCaptionBox(TableCaptionBox box) {
        return this.commonBuild((ElementBox)box, "table_caption_box");
    }

    private SimpleAttributeSet buildTableBodyBox(TableBodyBox box) {
        return this.commonBuild((ElementBox)box, "table_body_box");
    }

    private SimpleAttributeSet buildTableRowBox(TableRowBox box) {
        return this.commonBuild((ElementBox)box, "table_row_box");
    }

    private SimpleAttributeSet buildTableCellBox(TableCellBox box) {
        return this.commonBuild((ElementBox)box, "table_cell_box");
    }

    private SimpleAttributeSet buildTableColumn(TableColumn box) {
        return this.commonBuild((ElementBox)box, "table_column");
    }

    private SimpleAttributeSet buildTableColumnGroup(TableColumnGroup box) {
        return this.commonBuild((ElementBox)box, "table_column_group");
    }

    private SimpleAttributeSet buildListItemBox(ListItemBox box) {
        return this.commonBuild((ElementBox)box, "list_item_box");
    }

    private final SimpleAttributeSet commonBuild(ElementBox box, Object elementNameValue) {
        SimpleAttributeSet attr = new SimpleAttributeSet();
        attr.addAttribute("$ename", elementNameValue);
        attr.addAttribute("attribute_anchor_reference", new Anchor());
        attr.addAttribute("attribute_box_reference", box);
        attr.addAttribute("element_id", box.getElement().getAttribute("id"));
        return attr;
    }

    public void startElementContents(ElementBox elem) {
        if (!elem.isReplaced()) {
            SimpleAttributeSet attr = this.buildElement(elem);
            attr.addAttribute("attribute_drawing_order", this.order++);
            this.elements.add(new DefaultStyledDocument.ElementSpec(attr, 1, "{".toCharArray(), 1, 0));
        }
    }

    public void finishElementContents(ElementBox elem) {
        if (!elem.isReplaced()) {
            SimpleAttributeSet attr = this.buildElement(elem);
            this.elements.add(new DefaultStyledDocument.ElementSpec(attr, 2, "}".toCharArray(), 1, 0));
        }
    }

    public void renderElementBackground(ElementBox elem) {
        SimpleAttributeSet attr = this.buildElementBackground(elem);
        attr.addAttribute("attribute_drawing_order", this.order++);
        this.elements.add(new DefaultStyledDocument.ElementSpec(attr, 3, "*".toCharArray(), 0, 1));
    }

    public void renderTextContent(TextBox box) {
        String text = box.getText();
        SimpleAttributeSet attr = this.buildText(box);
        attr.addAttribute("attribute_drawing_order", this.order++);
        this.elements.add(new DefaultStyledDocument.ElementSpec(attr, 3, text.toCharArray(), 0, text.length()));
    }

    public void renderReplacedContent(ReplacedBox box) {
        Element elem = ((ElementBox)box).getElement();
        String text = "";
        text = "img".equalsIgnoreCase(elem.getTagName()) ? " [" + elem.getAttribute("alt") + " Location: " + elem.getAttribute("src") + "] " : "{object}";
        SimpleAttributeSet attr = this.buildReplacedBox(box);
        attr.addAttribute("attribute_drawing_order", this.order++);
        this.elements.add(new DefaultStyledDocument.ElementSpec(attr, 3, text.toCharArray(), 0, text.length()));
    }

    public void close() {
    }
}

