/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.swingbox.demo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import org.fit.cssbox.css.CSSNorm;
import org.fit.cssbox.css.DOMAnalyzer;
import org.fit.cssbox.io.DefaultDOMSource;
import org.fit.cssbox.io.DefaultDocumentSource;
import org.fit.cssbox.io.DocumentSource;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.BrowserCanvas;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.swingbox.BrowserPane;
import org.fit.cssbox.swingbox.demo.BrowserComparisonHyperlinkHandler;
import org.fit.cssbox.swingbox.util.GeneralEvent;
import org.fit.cssbox.swingbox.util.GeneralEventListener;
import org.w3c.dom.Document;

public class BrowserComparison
extends JFrame {
    private static final long serialVersionUID = 3078719188136612454L;
    BrowserPane swingbox = new BrowserPane();
    BrowserCanvas cssbox = null;
    JEditorPane editorkit = new JEditorPane();
    JTextField txt = new JTextField("http://www.aktualne.cz", 60);
    JScrollPane contentScroll = new JScrollPane();

    public BrowserComparison() {
        this.init();
        this.loadPage(this.txt.getText());
    }

    private void init() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel tmp = new JPanel(new FlowLayout(0));
        JButton btn = new JButton("  GO!  ");
        tmp.add(this.txt);
        tmp.add(btn);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        BrowserComparison.this.loadPage(BrowserComparison.this.txt.getText());
                    }
                });
                t.setDaemon(true);
                t.start();
            }
        });
        this.txt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        BrowserComparison.this.loadPage(BrowserComparison.this.txt.getText());
                    }
                });
                t.setDaemon(true);
                t.start();
            }
        });
        JTabbedPane tab = new JTabbedPane(1);
        tab.addTab("SwingBox", new JScrollPane(this.swingbox));
        tab.addTab("CSSBox", this.contentScroll);
        tab.addTab("JEditorPane + HTMLEditorKit", new JScrollPane(this.editorkit));
        panel.add((Component)tmp, "North");
        panel.add((Component)tab, "Center");
        this.setContentPane(panel);
        this.swingbox.addHyperlinkListener(new BrowserComparisonHyperlinkHandler(this));
        this.swingbox.addGeneralEventListener(new GeneralEventListener(){
            private long time;

            @Override
            public void generalEventUpdate(GeneralEvent e) {
                if (e.event_type == GeneralEvent.EventType.page_loading_begin) {
                    this.time = System.currentTimeMillis();
                } else if (e.event_type == GeneralEvent.EventType.page_loading_end) {
                    System.out.println("SwingBox: page loaded in: " + (System.currentTimeMillis() - this.time) + " ms");
                }
            }
        });
        this.editorkit.setEditorKit(new HTMLEditorKit());
        this.editorkit.setEditable(false);
        this.editorkit.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
            }
        });
        this.contentScroll.setViewportView((Component)this.cssbox);
        this.contentScroll.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (BrowserComparison.this.cssbox != null && BrowserComparison.this.cssbox instanceof BrowserCanvas) {
                    BrowserComparison.this.cssbox.createLayout(BrowserComparison.this.contentScroll.getSize());
                    BrowserComparison.this.contentScroll.repaint();
                }
            }
        });
        this.setResizable(true);
        this.setDefaultCloseOperation(3);
        this.setPreferredSize(new Dimension(1200, 1000));
        this.setTitle("Demo");
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public void loadPage(String page) {
        if (!(page.startsWith("http:") || page.startsWith("ftp:") || page.startsWith("file:"))) {
            page = "http://" + page;
        }
        this.txt.setText(page);
        this.loadPage_editorkit(page);
        this.loadPage_cssbox(page);
        this.loadPage_swingbox(page);
    }

    private void loadPage_swingbox(String url) {
        try {
            this.swingbox.setPage(new URL(url));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPage_cssbox(String urlstring) {
        InputStream is = null;
        try {
            DefaultDocumentSource docSource = new DefaultDocumentSource(urlstring);
            DefaultDOMSource parser = new DefaultDOMSource((DocumentSource)docSource);
            Document doc = parser.parse();
            DOMAnalyzer da = new DOMAnalyzer(doc, docSource.getURL());
            da.attributesToStyles();
            da.addStyleSheet(null, CSSNorm.stdStyleSheet(), DOMAnalyzer.Origin.AGENT);
            da.addStyleSheet(null, CSSNorm.userStyleSheet(), DOMAnalyzer.Origin.AGENT);
            da.getStyleSheets();
            this.cssbox = new BrowserCanvas(da.getRoot(), da, docSource.getURL());
            this.cssbox.getConfig().setLoadBackgroundImages(true);
            this.cssbox.getConfig().setLoadImages(true);
            this.cssbox.createLayout(this.contentScroll.getSize());
            this.cssbox.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    System.out.println("Click: " + e.getX() + ":" + e.getY());
                    Box node = BrowserComparison.this.locateBox((Box)BrowserComparison.this.cssbox.getViewport(), e.getX(), e.getY());
                    System.out.println("Box: " + node);
                    if (node != null) {
                        node.drawExtent(BrowserComparison.this.cssbox.getImageGraphics());
                        BrowserComparison.this.cssbox.repaint();
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
            this.contentScroll.setViewportView((Component)this.cssbox);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void loadPage_editorkit(String url) {
        try {
            this.editorkit.setPage(new URL(url));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Box locateBox(Box root, int x, int y) {
        if (root.isVisible()) {
            Box found = null;
            Rectangle bounds = root.getAbsoluteBounds();
            if (bounds.contains(x, y)) {
                found = root;
                System.out.println("Fnd: " + found);
                found.drawExtent(this.cssbox.getImageGraphics());
            }
            if (root instanceof ElementBox) {
                ElementBox eb = (ElementBox)root;
                for (int i = eb.getStartChild(); i < eb.getEndChild(); ++i) {
                    Box inside = this.locateBox(((ElementBox)root).getSubBox(i), x, y);
                    if (inside == null) continue;
                    if (found == null) {
                        found = inside;
                        continue;
                    }
                    if (inside.getAbsoluteBounds().width * inside.getAbsoluteBounds().height >= found.getAbsoluteBounds().width * found.getAbsoluteBounds().height) continue;
                    found = inside;
                }
            }
            return found;
        }
        return null;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new BrowserComparison();
            }
        });
    }
}

