/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.csskit.antlr;

import cz.vutbr.web.css.CSSException;
import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.MediaQuery;
import cz.vutbr.web.css.NetworkProcessor;
import cz.vutbr.web.css.RuleBlock;
import cz.vutbr.web.css.RuleList;
import cz.vutbr.web.css.StyleSheet;
import cz.vutbr.web.csskit.antlr.CSSInputStream;
import cz.vutbr.web.csskit.antlr.DefaultCSSLexer;
import cz.vutbr.web.csskit.antlr.DefaultCSSParser;
import cz.vutbr.web.csskit.antlr.DefaultCSSParser_CSSParser;
import cz.vutbr.web.csskit.antlr.DefaultCSSTreeParser;
import cz.vutbr.web.csskit.antlr.Preparator;
import cz.vutbr.web.csskit.antlr.SimplePreparator;
import cz.vutbr.web.csskit.antlr.TreeUtil;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;
import org.fit.net.DataURLHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class CSSParserFactory {
    private static final Logger log = LoggerFactory.getLogger(CSSParserFactory.class);
    private static CSSParserFactory instance;

    protected static CSSInputStream getInput(Object source, NetworkProcessor network, String encoding, SourceType type) throws IOException {
        switch (type) {
            case INLINE: 
            case EMBEDDED: {
                return CSSInputStream.stringStream((String)source);
            }
            case URL: {
                return CSSInputStream.urlStream((URL)source, network, encoding);
            }
        }
        throw new RuntimeException("Coding error");
    }

    private static CommonTree getAST(DefaultCSSParser parser, SourceType type) throws CSSException {
        switch (type) {
            case INLINE: {
                try {
                    DefaultCSSParser_CSSParser.inlinestyle_return retval = parser.inlinestyle();
                    return (CommonTree)retval.getTree();
                }
                catch (RecognitionException re) {
                    throw CSSParserFactory.encapsulateException(re, "Unable to parse inline CSS style");
                }
                catch (RuntimeException re) {
                    throw CSSParserFactory.encapsulateException(re, "Unable to parse inline CSS style");
                }
            }
            case EMBEDDED: {
                try {
                    DefaultCSSParser_CSSParser.stylesheet_return retval = parser.stylesheet();
                    return (CommonTree)retval.getTree();
                }
                catch (RecognitionException re) {
                    throw CSSParserFactory.encapsulateException(re, "Unable to parse embedded CSS style");
                }
                catch (RuntimeException re) {
                    throw CSSParserFactory.encapsulateException(re, "Unable to parse embedded CSS style");
                }
            }
            case URL: {
                try {
                    DefaultCSSParser_CSSParser.stylesheet_return retval = parser.stylesheet();
                    return (CommonTree)retval.getTree();
                }
                catch (RecognitionException re) {
                    throw CSSParserFactory.encapsulateException(re, "Unable to parse URL CSS style");
                }
                catch (RuntimeException re) {
                    throw CSSParserFactory.encapsulateException(re, "Unable to parse URL CSS style");
                }
            }
        }
        throw new RuntimeException("Coding error");
    }

    private static RuleList parse(DefaultCSSTreeParser parser, SourceType type) throws CSSException {
        switch (type) {
            case INLINE: {
                try {
                    return parser.inlinestyle();
                }
                catch (RecognitionException re) {
                    throw CSSParserFactory.encapsulateException(re, "Unable to parse inline CSS style [AST]");
                }
                catch (RuntimeException re) {
                    throw CSSParserFactory.encapsulateException(re, "Unable to parse inline CSS style [AST]");
                }
            }
            case EMBEDDED: {
                try {
                    return parser.stylesheet();
                }
                catch (RecognitionException re) {
                    throw CSSParserFactory.encapsulateException(re, "Unable to parse embedded CSS style [AST]");
                }
                catch (RuntimeException re) {
                    throw CSSParserFactory.encapsulateException(re, "Unable to parse embedded CSS style [AST]");
                }
            }
            case URL: {
                try {
                    return parser.stylesheet();
                }
                catch (RecognitionException re) {
                    throw CSSParserFactory.encapsulateException(re, "Unable to parse file CSS style [AST]");
                }
                catch (RuntimeException re) {
                    throw CSSParserFactory.encapsulateException(re, "Unable to parse file CSS style [AST]");
                }
            }
        }
        throw new RuntimeException("Coding error");
    }

    protected static CSSException encapsulateException(Throwable t, String msg) {
        log.error("THROWN:", t);
        return new CSSException(msg, t);
    }

    protected CSSParserFactory() {
    }

    public static CSSParserFactory getInstance() {
        if (instance == null) {
            instance = new CSSParserFactory();
        }
        return instance;
    }

    public StyleSheet parse(Object source, NetworkProcessor network, String encoding, SourceType type, Element inline, boolean inlinePriority, URL base) throws IOException, CSSException {
        StyleSheet sheet = (StyleSheet)CSSFactory.getRuleFactory().createStyleSheet().unlock();
        SimplePreparator preparator = new SimplePreparator(inline, inlinePriority);
        StyleSheet ret = this.parseAndImport(source, network, encoding, type, sheet, preparator, base, null);
        return ret;
    }

    public StyleSheet parse(Object source, NetworkProcessor network, String encoding, SourceType type, URL base) throws IOException, CSSException {
        if (type == SourceType.INLINE) {
            throw new IllegalArgumentException("Missing element for INLINE input");
        }
        return this.parse(source, network, encoding, type, null, false, base);
    }

    public StyleSheet append(Object source, NetworkProcessor network, String encoding, SourceType type, Element inline, boolean inlinePriority, StyleSheet sheet, URL base) throws IOException, CSSException {
        SimplePreparator preparator = new SimplePreparator(inline, inlinePriority);
        StyleSheet ret = this.parseAndImport(source, network, encoding, type, sheet, preparator, base, null);
        return ret;
    }

    public StyleSheet append(Object source, NetworkProcessor network, String encoding, SourceType type, StyleSheet sheet, URL base) throws IOException, CSSException {
        if (type == SourceType.INLINE) {
            throw new IllegalArgumentException("Missing element for INLINE input");
        }
        return this.append(source, network, encoding, type, null, false, sheet, base);
    }

    protected StyleSheet parseAndImport(Object source, NetworkProcessor network, String encoding, SourceType type, StyleSheet sheet, Preparator preparator, URL base, List<MediaQuery> media) throws CSSException, IOException {
        DefaultCSSTreeParser parser = CSSParserFactory.createTreeParser(source, network, encoding, type, preparator, base, media);
        CSSParserFactory.parse(parser, type);
        for (int i = 0; i < parser.getImportPaths().size(); ++i) {
            String path = parser.getImportPaths().get(i);
            List<MediaQuery> imedia = parser.getImportMedia().get(i);
            if ((imedia == null || imedia.isEmpty()) && CSSFactory.getAutoImportMedia().matchesEmpty() || CSSFactory.getAutoImportMedia().matchesOneOf(imedia)) {
                URL url = DataURLHandler.createURL(base, path);
                try {
                    this.parseAndImport(url, network, encoding, SourceType.URL, sheet, preparator, url, imedia);
                }
                catch (IOException e) {
                    log.warn("Couldn't read imported style sheet: {}", (Object)e.getMessage());
                }
                continue;
            }
            log.trace("Skipping import {} (media not matching)", (Object)path);
        }
        return CSSParserFactory.addRulesToStyleSheet(parser.getRules(), sheet);
    }

    protected static StyleSheet addRulesToStyleSheet(RuleList rules, StyleSheet sheet) {
        if (rules != null) {
            for (RuleBlock rule : rules) {
                sheet.add(rule);
            }
        }
        return sheet;
    }

    private static DefaultCSSTreeParser createTreeParser(Object source, NetworkProcessor network, String encoding, SourceType type, Preparator preparator, URL base, List<MediaQuery> media) throws IOException, CSSException {
        CSSInputStream input = CSSParserFactory.getInput(source, network, encoding, type);
        input.setBase(base);
        CommonTokenStream tokens = CSSParserFactory.feedLexer(input);
        CommonTree ast = CSSParserFactory.feedParser(tokens, type);
        return CSSParserFactory.feedAST(tokens, ast, preparator, media);
    }

    private static CommonTokenStream feedLexer(CSSInputStream source) throws CSSException {
        try {
            DefaultCSSLexer lexer = new DefaultCSSLexer(source);
            lexer.init();
            return new CommonTokenStream((TokenSource)lexer);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof CSSException) {
                throw (CSSException)re.getCause();
            }
            log.error("LEXER THROWS:", (Throwable)re);
            throw re;
        }
    }

    private static CommonTree feedParser(CommonTokenStream source, SourceType type) throws CSSException {
        DefaultCSSParser parser = new DefaultCSSParser((TokenStream)source);
        parser.init();
        return CSSParserFactory.getAST(parser, type);
    }

    private static DefaultCSSTreeParser feedAST(CommonTokenStream source, CommonTree ast, Preparator preparator, List<MediaQuery> media) {
        if (log.isTraceEnabled()) {
            log.trace("Feeding tree parser with AST:\n{}", (Object)TreeUtil.toStringTree(ast));
        }
        CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)ast);
        nodes.setTokenStream((TokenStream)source);
        DefaultCSSTreeParser parser = new DefaultCSSTreeParser((TreeNodeStream)nodes);
        parser.init(preparator, media);
        return parser;
    }

    public List<MediaQuery> parseMediaQuery(String query) {
        try {
            CSSInputStream input = CSSInputStream.stringStream(query);
            input.setBase(new URL("file://media/query/url"));
            CommonTokenStream tokens = CSSParserFactory.feedLexer(input);
            DefaultCSSParser parser = new DefaultCSSParser((TokenStream)tokens);
            parser.init();
            DefaultCSSParser_CSSParser.media_return retval = parser.media();
            CommonTree ast = (CommonTree)retval.getTree();
            DefaultCSSTreeParser tparser = CSSParserFactory.feedAST(tokens, ast, null, null);
            return tparser.media();
        }
        catch (IOException e) {
            log.error("I/O error during media query parsing: {}", (Object)e.getMessage());
            return null;
        }
        catch (CSSException e) {
            log.warn("Malformed media query {}", (Object)query);
            return null;
        }
        catch (RecognitionException e) {
            log.warn("Malformed media query {}", (Object)query);
            return null;
        }
    }

    public static enum SourceType {
        INLINE,
        EMBEDDED,
        URL;

    }
}

