/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.csskit;

import cz.vutbr.web.css.Selector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class ElementUtil {
    public static final String CLASS_DELIM = " ";
    public static final String CLASS_ATTR = "class";
    public static final String ID_ATTR = "id";

    public static String getAttribute(Element e, String name) {
        return e.hasAttribute(name) ? e.getAttribute(name) : "";
    }

    public static Collection<String> elementClasses(Element e) {
        if (e.hasAttribute(CLASS_ATTR)) {
            String classNames = ElementUtil.getAttribute(e, CLASS_ATTR);
            ArrayList<String> list = new ArrayList<String>();
            for (String cname : classNames.toLowerCase().split(CLASS_DELIM)) {
                if ((cname = cname.trim()).length() <= 0) continue;
                list.add(cname);
            }
            return list;
        }
        return Collections.emptyList();
    }

    public static boolean matchesClassOld(Element e, String className) {
        if (e.hasAttribute(CLASS_ATTR)) {
            String classNames = ElementUtil.getAttribute(e, CLASS_ATTR).toLowerCase();
            int len = className.length();
            int start = classNames.indexOf(className.toLowerCase());
            if (start == -1) {
                return false;
            }
            return !(start != 0 && !Character.isWhitespace(classNames.charAt(start - 1)) || start + len != classNames.length() && !Character.isWhitespace(classNames.charAt(start + len)));
        }
        return false;
    }

    public static boolean matchesClass(Element e, String className) {
        if (e.hasAttribute(CLASS_ATTR)) {
            String classNames = ElementUtil.getAttribute(e, CLASS_ATTR).toLowerCase();
            String search = className.toLowerCase();
            int len = className.length();
            int lastIndex = 0;
            while ((lastIndex = classNames.indexOf(search, lastIndex)) != -1) {
                if ((lastIndex == 0 || Character.isWhitespace(classNames.charAt(lastIndex - 1))) && (lastIndex + len == classNames.length() || Character.isWhitespace(classNames.charAt(lastIndex + len)))) {
                    return true;
                }
                lastIndex += len;
            }
            return false;
        }
        return false;
    }

    public static String elementID(Element e) {
        String id = ElementUtil.getAttribute(e, ID_ATTR);
        return id;
    }

    public static boolean matchesID(Element e, String id) {
        return id.equalsIgnoreCase(ElementUtil.elementID(e));
    }

    public static String elementName(Element e) {
        String name = e.getNodeName();
        return name;
    }

    public static boolean matchesName(Element e, String name) {
        if (name == null) {
            return false;
        }
        return name.equalsIgnoreCase(ElementUtil.elementName(e));
    }

    public static boolean matchesAttribute(Element e, String name, String value, Selector.Operator o) {
        Attr attributeNode = e.getAttributeNode(name);
        if (attributeNode != null && o != null) {
            String attributeValue = attributeNode.getNodeValue();
            switch (o) {
                case EQUALS: {
                    return attributeValue.equals(value);
                }
                case INCLUDES: {
                    if (value.isEmpty() || ElementUtil.containsWhitespace(value)) {
                        return false;
                    }
                    attributeValue = CLASS_DELIM + attributeValue + CLASS_DELIM;
                    return attributeValue.matches(".* " + value + " .*");
                }
                case DASHMATCH: {
                    return attributeValue.matches("^" + value + "(-.*|$)");
                }
                case CONTAINS: {
                    return !value.isEmpty() && attributeValue.matches(".*" + value + ".*");
                }
                case STARTSWITH: {
                    return !value.isEmpty() && attributeValue.matches("^" + value + ".*");
                }
                case ENDSWITH: {
                    return !value.isEmpty() && attributeValue.matches(".*" + value + "$");
                }
            }
            return true;
        }
        return false;
    }

    private static boolean containsWhitespace(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isWhitespace(s.charAt(i))) continue;
            return true;
        }
        return false;
    }
}

