/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.hibernate3;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.jcip.annotations.ThreadSafe;
import net.sf.beanlib.hibernate.UnEnhancer;
import net.sf.beanlib.provider.replicator.CollectionReplicator;
import net.sf.beanlib.spi.BeanTransformerSpi;
import net.sf.beanlib.spi.replicator.CollectionReplicatorSpi;
import net.sf.beanlib.utils.ClassUtils;
import org.hibernate.Hibernate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hibernate3CollectionReplicator
extends CollectionReplicator {
    private static final Factory factory = new Factory();

    public static final Factory getFactory() {
        return factory;
    }

    public static Hibernate3CollectionReplicator newCollectionReplicatable(BeanTransformerSpi beanTransformer) {
        return factory.newCollectionReplicatable(beanTransformer);
    }

    protected Hibernate3CollectionReplicator(BeanTransformerSpi beanTransformer) {
        super(beanTransformer);
    }

    public <V, T> T replicateCollection(Collection<V> from, Class<T> toClass) {
        if (!Hibernate.isInitialized(from)) {
            Hibernate.initialize(from);
        }
        return (T)super.replicateCollection(from, toClass);
    }

    protected <T> Collection<T> createToCollection(Collection<T> from) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException, InvocationTargetException {
        Class<?> fromClass = from.getClass();
        if (ClassUtils.isJavaPackage(fromClass)) {
            SortedSet fromSortedSet;
            Comparator toComparator;
            if (from instanceof SortedSet && (toComparator = this.createToComparator(fromSortedSet = (SortedSet)from)) != null) {
                return this.createToSortedSetWithComparator(fromSortedSet, toComparator);
            }
            return this.createToInstanceAsCollection(from);
        }
        if (from instanceof SortedSet) {
            SortedSet fromSortedSet = (SortedSet)from;
            Comparator toComparator = this.createToComparator(fromSortedSet);
            if (ClassUtils.isHibernatePackage(fromClass)) {
                return new TreeSet(toComparator);
            }
            Constructor<?> constructor = fromClass.getConstructor(Comparator.class);
            Object[] initargs = new Object[]{toComparator};
            Collection ret = (Collection)constructor.newInstance(initargs);
            return ret;
        }
        if (from instanceof Set) {
            if (ClassUtils.isHibernatePackage(fromClass)) {
                return new HashSet();
            }
            Collection ret = (Collection)fromClass.newInstance();
            return ret;
        }
        if (from instanceof List) {
            if (ClassUtils.isHibernatePackage(fromClass)) {
                return new ArrayList(from.size());
            }
            Collection ret = (Collection)fromClass.newInstance();
            return ret;
        }
        this.log.warn((Object)("Don't know what collection object:" + fromClass + ", so assume List."));
        return new ArrayList(from.size());
    }

    protected <T> T createToInstance(Object from, Class<T> toClass) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException {
        Class actualClass = UnEnhancer.getActualClass(from);
        Class targetClass = this.chooseClass(actualClass, toClass);
        return (T)this.newInstanceAsPrivileged(targetClass);
    }

    protected <T> T replicate(T from) {
        return (T)super.replicate(UnEnhancer.unenhanceObject(from));
    }

    @ThreadSafe
    public static class Factory
    implements CollectionReplicatorSpi.Factory {
        private Factory() {
        }

        public Hibernate3CollectionReplicator newCollectionReplicatable(BeanTransformerSpi beanTransformer) {
            return new Hibernate3CollectionReplicator(beanTransformer);
        }
    }
}

