/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.hibernate;

import net.sf.cglib.proxy.Enhancer;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnEnhancer {
    private static final String JAVASSIST_STARTWITH = "org.javassist.tmp.";
    private static final String JAVASSIST_INDEXOF = "_$$_javassist_";

    private UnEnhancer() {
    }

    private static boolean isJavassistEnhanced(Class c) {
        String className = c.getName();
        return className.startsWith(JAVASSIST_STARTWITH) || className.indexOf(JAVASSIST_INDEXOF) != -1;
    }

    public static <T> Class<T> unenhanceClass(Class c) {
        boolean enhanced = true;
        while (c != null && enhanced) {
            boolean bl = enhanced = Enhancer.isEnhanced((Class)c) || UnEnhancer.isJavassistEnhanced(c);
            if (!enhanced) continue;
            c = c.getSuperclass();
        }
        return c;
    }

    public static <T> Class<T> getActualClass(Object object) {
        Class<?> c = object.getClass();
        boolean enhanced = true;
        while (c != null && enhanced) {
            boolean bl = enhanced = Enhancer.isEnhanced(c) || UnEnhancer.isJavassistEnhanced(c);
            if (!enhanced) continue;
            if (object instanceof HibernateProxy) {
                HibernateProxy hibernateProxy = (HibernateProxy)object;
                LazyInitializer lazyInitializer = hibernateProxy.getHibernateLazyInitializer();
                try {
                    Object impl = lazyInitializer.getImplementation();
                    if (impl != null) {
                        return impl.getClass();
                    }
                }
                catch (HibernateException ex) {
                    Logger.getLogger(UnEnhancer.class).warn((Object)"Unable to retrieve the underlying persistent object", (Throwable)ex);
                }
                return lazyInitializer.getPersistentClass();
            }
            c = c.getSuperclass();
        }
        return c;
    }

    public static <T> T unenhanceObject(T object) {
        if (object == null) {
            return null;
        }
        Class<?> c = object.getClass();
        boolean enhanced = true;
        while (c != null && enhanced) {
            boolean bl = enhanced = Enhancer.isEnhanced(c) || UnEnhancer.isJavassistEnhanced(c);
            if (!enhanced) continue;
            if (object instanceof HibernateProxy) {
                HibernateProxy hibernateProxy = (HibernateProxy)object;
                LazyInitializer lazyInitializer = hibernateProxy.getHibernateLazyInitializer();
                return (T)lazyInitializer.getImplementation();
            }
            c = c.getSuperclass();
        }
        return object;
    }
}

