/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.conditions;

import java.util.Arrays;
import net.serenitybdd.markers.IsSilent;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.NoMatchingAbilityException;
import net.serenitybdd.screenplay.Performable;
import net.serenitybdd.screenplay.Tasks;
import net.serenitybdd.screenplay.conditions.PossibleAction;

public class PerformBasedOnAbility
implements Performable,
IsSilent {
    private final PossibleAction[] possibleActions;

    public PerformBasedOnAbility(PossibleAction ... possibleActions) {
        this.possibleActions = possibleActions;
    }

    public static PerformBasedOnAbility checkInOrder(PossibleAction ... possibleActions) {
        return Tasks.instrumented(PerformBasedOnAbility.class, new Object[]{possibleActions});
    }

    @Override
    public <T extends Actor> void performAs(T actor) {
        Performable[] firstTasksMatchingAbility = Arrays.stream(this.possibleActions).filter(task -> actor.abilityTo(task.getAbility()) != null).findFirst().orElseThrow(() -> new NoMatchingAbilityException(actor.getName())).getTasks();
        actor.attemptsTo(firstTasksMatchingAbility);
    }
}

