/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.waits;

import java.time.Duration;
import net.serenitybdd.markers.IsSilent;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Interaction;
import net.serenitybdd.screenplay.abilities.BrowseTheWeb;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.environment.SystemEnvironmentVariables;
import org.openqa.selenium.support.ui.ExpectedCondition;

public class WaitUntilExpectation<T>
implements Interaction,
IsSilent {
    private ExpectedCondition<T> expectedCondition;
    private Duration duration;

    public WaitUntilExpectation(ExpectedCondition<T> expectedCondition) {
        this.expectedCondition = expectedCondition;
        int durationInMillis = SystemEnvironmentVariables.currentEnvironmentVariables().getPropertyAsInteger((Enum)ThucydidesSystemProperty.WEBDRIVER_WAIT_FOR_TIMEOUT, Integer.valueOf(3000));
        this.duration = Duration.ofMillis(durationInMillis);
    }

    public <A extends Actor> void performAs(A actor) {
        BrowseTheWeb.as(actor).withTimeoutOf(this.duration).waitFor(this.expectedCondition);
    }

    public Interaction forNoMoreThan(Duration duration) {
        this.duration = duration;
        return this;
    }
}

