/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.ui;

import net.serenitybdd.screenplay.targets.SearchableTarget;
import net.serenitybdd.screenplay.targets.Target;
import net.serenitybdd.screenplay.ui.CSSAttributeValue;
import net.serenitybdd.screenplay.ui.LocatorStrategies;
import net.serenitybdd.screenplay.ui.TargetFactory;
import org.openqa.selenium.By;

public class TextArea {
    private static final String BY_ID_OR_NAME = "css:textarea[id='{0}' i],textarea[name='{0}' i],textarea[data-test='{0}' i],[aria-label='{0}' i]";
    private static final String ARIA_LABEL = "textarea[aria-label='{0}' i]";

    public static SearchableTarget withNameOrId(String name) {
        return Target.the("the '" + name + "' text area").locatedBy(BY_ID_OR_NAME).of(name);
    }

    public static SearchableTarget withPlaceholder(String placeholderName) {
        String placeholderAttribute = CSSAttributeValue.withEscapedQuotes(placeholderName);
        return Target.the("'" + placeholderName + "' field").locatedBy("css:[placeholder='{0}']").of(placeholderAttribute);
    }

    public static Target withLabel(String labelText) {
        return Target.the(labelText + " text area").locatedBy(LocatorStrategies.fieldWithLabel(labelText));
    }

    public static SearchableTarget withAriaLabel(String name) {
        return Target.the("'" + name + "' text area").locatedByFirstMatching("css:textarea[aria-label='{0}' i]").of(name);
    }

    public static SearchableTarget withCSSClass(String className) {
        return TargetFactory.forElementOfType("text area").withCSSClass(className);
    }

    public static SearchableTarget locatedBy(String selector) {
        return TargetFactory.forElementOfType("text area").locatedByXPathOrCss(selector);
    }

    public static SearchableTarget located(By selector) {
        return TargetFactory.forElementOfType("text area").locatedBy(selector);
    }
}

