/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.targets;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.core.pages.ListOfWebElementFacades;
import net.serenitybdd.core.pages.PageObject;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.core.pages.WebElementFacadeImpl;
import net.serenitybdd.screenplay.targets.HasByLocator;
import net.serenitybdd.screenplay.targets.IFrame;
import net.serenitybdd.screenplay.targets.SearchableTarget;
import net.serenitybdd.screenplay.targets.Target;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class ByTarget
extends SearchableTarget
implements HasByLocator {
    private By locator;

    public ByTarget(String targetElementName, By locator, Optional<IFrame> iFrame) {
        super(targetElementName, iFrame);
        this.locator = locator;
    }

    public ByTarget(String targetElementName, Optional<IFrame> iFrame, Optional<Duration> timeout) {
        super(targetElementName, iFrame, timeout);
    }

    protected ByTarget(String targetElementName, By locator, Optional<IFrame> iFrame, Optional<Duration> timeout) {
        super(targetElementName, iFrame, timeout);
        this.locator = locator;
    }

    @Override
    public WebElementFacade resolveFor(PageObject page) {
        if (this.timeout.isPresent()) {
            return page.withTimeoutOf((Duration)this.timeout.get()).find(this.locator);
        }
        return page.find(this.locator);
    }

    @Override
    public ListOfWebElementFacades resolveAllFor(PageObject page) {
        if (this.timeout.isPresent()) {
            return new ListOfWebElementFacades((Collection)page.withTimeoutOf((Duration)this.timeout.get()).findAll(this.locator));
        }
        return new ListOfWebElementFacades((Collection)page.findAll(this.locator));
    }

    public WebElementFacade resolveFor(SearchContext searchContext) {
        return WebElementFacadeImpl.wrapWebElement((WebDriver)Serenity.getDriver(), (WebElement)searchContext.findElement(this.locator));
    }

    public ListOfWebElementFacades resolveAllFor(SearchContext searchContext) {
        List matchingElements = searchContext.findElements(this.locator);
        return WebElementFacadeImpl.fromWebElements((List)matchingElements);
    }

    @Override
    public SearchableTarget of(String ... parameters) {
        throw new UnsupportedOperationException("The of() method is not supported for By-type Targets");
    }

    @Override
    public String getCssOrXPathSelector() {
        throw new UnsupportedOperationException("The getCssOrXPathSelector() method is not supported for By-type Targets");
    }

    @Override
    public Target waitingForNoMoreThan(Duration timeout) {
        return new ByTarget(this.targetElementName, this.locator, this.iFrame, Optional.ofNullable(timeout));
    }

    @Override
    public List<By> selectors(WebDriver driver) {
        return Collections.singletonList(this.locator);
    }

    @Override
    public ByTarget called(String name) {
        return new ByTarget(name, this.locator, this.iFrame, this.timeout);
    }

    @Override
    public List<String> getCssOrXPathSelectors() {
        throw new UnsupportedOperationException("The getCssOrXPathSelector() method is not supported for By Targets");
    }

    @Override
    public By getLocator() {
        return this.locator;
    }
}

