/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.questions;

import java.util.Set;
import net.serenitybdd.core.pages.ListOfWebElementFacades;
import net.serenitybdd.core.pages.WebElementState;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Question;
import net.serenitybdd.screenplay.annotations.Subject;
import net.serenitybdd.screenplay.matchers.statematchers.CheckForAbsenceHint;
import net.serenitybdd.screenplay.matchers.statematchers.MissingWebElement;
import net.serenitybdd.screenplay.questions.AcceptsHints;
import net.serenitybdd.screenplay.questions.QuestionHint;
import net.serenitybdd.screenplay.questions.UnresolvedTargetWebElementState;
import net.serenitybdd.screenplay.targets.Target;
import org.openqa.selenium.By;

@Subject(value="#target")
public class WebElementQuestion
implements Question<WebElementState>,
AcceptsHints {
    private final Target target;
    private boolean checkForAbsence = false;

    public WebElementQuestion(Target target) {
        this.target = target;
    }

    public static Question<WebElementState> stateOf(Target target) {
        return new WebElementQuestion(target);
    }

    public static Question<WebElementState> stateOf(String xpathOrCssSelector) {
        return new WebElementQuestion(Target.the(xpathOrCssSelector).locatedBy(xpathOrCssSelector));
    }

    public static Question<WebElementState> stateOf(By byLocator) {
        return new WebElementQuestion(Target.the(byLocator.toString()).located(byLocator));
    }

    public static Question<WebElementState> valueOf(Target target) {
        return WebElementQuestion.stateOf(target);
    }

    public static Question<WebElementState> valueOf(String xpathOrCssSelector) {
        return WebElementQuestion.stateOf(xpathOrCssSelector);
    }

    public static Question<WebElementState> valueOf(By byLocator) {
        return WebElementQuestion.stateOf(byLocator);
    }

    public static Question<WebElementState> the(Target target) {
        return WebElementQuestion.stateOf(target);
    }

    public static Question<WebElementState> the(String xpathOrCssSelector) {
        return WebElementQuestion.stateOf(xpathOrCssSelector);
    }

    public static Question<WebElementState> the(By byLocator) {
        return WebElementQuestion.stateOf(byLocator);
    }

    public WebElementState answeredBy(Actor actor) {
        return this.checkForAbsence ? this.checkForAbsenceBy(actor) : this.checkForPresenceBy(actor);
    }

    private WebElementState checkForAbsenceBy(Actor actor) {
        ListOfWebElementFacades matchingElements = this.target.resolveAllFor(actor);
        if (matchingElements.isEmpty()) {
            return new MissingWebElement(this.target.getName());
        }
        return (WebElementState)matchingElements.get(0);
    }

    private WebElementState checkForPresenceBy(Actor actor) {
        ListOfWebElementFacades matchingElements = this.target.resolveAllFor(actor);
        if (matchingElements.isEmpty()) {
            return new UnresolvedTargetWebElementState(this.target.getName());
        }
        return (WebElementState)matchingElements.get(0);
    }

    public void apply(Set<Class<? extends QuestionHint>> hints) {
        this.checkForAbsence = hints.contains(CheckForAbsenceHint.class);
    }
}

