/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.targets;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.serenitybdd.core.pages.PageObject;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.core.selectors.Selectors;
import net.serenitybdd.screenplay.targets.IFrame;
import net.serenitybdd.screenplay.targets.SearchableTarget;
import net.serenitybdd.screenplay.targets.Target;
import net.serenitybdd.screenplay.targets.TargetSelectorWithVariables;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

public class XPathOrCssTarget
extends SearchableTarget {
    private final String cssOrXPathSelector;

    public XPathOrCssTarget(String targetElementName, String cssOrXPathSelector, Optional<IFrame> iFrame, Optional<Duration> timeout) {
        super(targetElementName, iFrame, timeout);
        this.cssOrXPathSelector = cssOrXPathSelector;
    }

    @Override
    public WebElementFacade resolveFor(PageObject page) {
        if (this.timeout.isPresent()) {
            return page.withTimeoutOf((Duration)this.timeout.get()).find(this.cssOrXPathSelector);
        }
        return page.findBy(this.cssOrXPathSelector, new Object[0]);
    }

    @Override
    public List<WebElementFacade> resolveAllFor(PageObject page) {
        if (this.timeout.isPresent()) {
            return page.withTimeoutOf((Duration)this.timeout.get()).findAll(this.cssOrXPathSelector);
        }
        return page.findAll(this.cssOrXPathSelector, new Object[0]);
    }

    @Override
    public SearchableTarget of(String ... parameters) {
        return new XPathOrCssTarget(this.instantiated(this.targetElementName, parameters), this.instantiated(this.cssOrXPathSelector, parameters), this.iFrame, this.timeout);
    }

    @Override
    public Target called(String name) {
        return new XPathOrCssTarget(name, this.cssOrXPathSelector, this.iFrame, this.timeout);
    }

    @Override
    public List<String> getCssOrXPathSelectors() {
        return Collections.singletonList(this.cssOrXPathSelector);
    }

    @Override
    public String getCssOrXPathSelector() {
        return this.cssOrXPathSelector;
    }

    @Override
    public Target waitingForNoMoreThan(Duration timeout) {
        return new XPathOrCssTarget(this.targetElementName, this.cssOrXPathSelector, this.iFrame, Optional.ofNullable(timeout));
    }

    @Override
    public List<By> selectors(WebDriver driver) {
        return Collections.singletonList(Selectors.xpathOrCssSelector((String)this.cssOrXPathSelector));
    }

    private String instantiated(String cssOrXPathSelector, String[] parameters) {
        return new TargetSelectorWithVariables(cssOrXPathSelector).resolvedWith(parameters);
    }
}

