/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.targets;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.targets.IFrame;
import net.serenitybdd.screenplay.targets.TargetBuilder;

public abstract class Target {
    protected final String targetElementName;
    protected final Optional<IFrame> iFrame;
    protected final Optional<Duration> timeout;

    public Target(String targetElementName, Optional<IFrame> iFrame) {
        this.targetElementName = targetElementName;
        this.iFrame = iFrame;
        this.timeout = Optional.empty();
    }

    public Target(String targetElementName, Optional<IFrame> iFrame, Optional<Duration> timeout) {
        this.targetElementName = targetElementName;
        this.iFrame = iFrame;
        this.timeout = timeout;
    }

    public String toString() {
        return this.targetElementName;
    }

    public static TargetBuilder the(String targetElementName) {
        return new TargetBuilder(targetElementName);
    }

    public abstract WebElementFacade resolveFor(Actor var1);

    public abstract List<WebElementFacade> resolveAllFor(Actor var1);

    public abstract Target called(String var1);

    public abstract Target of(String ... var1);

    public abstract String getCssOrXPathSelector();

    public Optional<IFrame> getIFrame() {
        return this.iFrame;
    }

    public String getName() {
        return this.targetElementName;
    }

    public abstract Target waitingForNoMoreThan(Duration var1);
}

