/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.abilities;

import com.google.common.eventbus.Subscribe;
import net.serenitybdd.core.eventbus.Broadcaster;
import net.serenitybdd.core.pages.PageObject;
import net.serenitybdd.screenplay.Ability;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.RefersToActor;
import net.serenitybdd.screenplay.events.ActorAsksQuestion;
import net.serenitybdd.screenplay.events.ActorBeginsPerformanceEvent;
import net.serenitybdd.screenplay.events.ActorEndsPerformanceEvent;
import net.serenitybdd.screenplay.events.ActorPerformanceEvent;
import net.serenitybdd.screenplay.events.ActorPerforms;
import net.serenitybdd.screenplay.exceptions.ActorCannotBrowseTheWebException;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.steps.PageObjectDependencyInjector;
import net.thucydides.core.webdriver.SerenityWebdriverManager;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import net.thucydides.core.webdriver.WebdriverManager;
import org.openqa.selenium.WebDriver;

public class BrowseTheWeb
extends PageObject
implements Ability,
RefersToActor {
    private final WebdriverManager webdriverManager = ThucydidesWebDriverSupport.getWebdriverManager();
    private Actor actor;

    protected BrowseTheWeb(WebDriver browser) {
        super(browser);
        this.registerForEventNotification();
    }

    private void registerForEventNotification() {
        Broadcaster.getEventBus().register((Object)this);
    }

    public static BrowseTheWeb as(Actor actor) {
        if (actor.abilityTo(BrowseTheWeb.class) == null) {
            throw new ActorCannotBrowseTheWebException(actor.getName());
        }
        return (BrowseTheWeb)((Object)((BrowseTheWeb)actor.abilityTo(BrowseTheWeb.class)).asActor(actor));
    }

    public static BrowseTheWeb with(WebDriver browser) {
        return new BrowseTheWeb(browser);
    }

    public <T extends PageObject> T onPage(Class<T> pageObjectClass) {
        return this.on(pageObjectClass);
    }

    public <T extends PageObject> T onPageElement(Class<T> pageObjectClass) {
        return this.on(pageObjectClass);
    }

    public <T extends PageObject> T on(Class<T> pageObjectClass) {
        return (T)Pages.instrumentedPageObjectUsing(pageObjectClass, (WebDriver)this.getDriver());
    }

    @Subscribe
    public void perform(ActorPerforms performAction) {
        if (this.messageIsForThisActor((ActorPerformanceEvent)performAction)) {
            WebDriver driver = this.webdriverManager.getWebdriver();
            PageObjectDependencyInjector injector = new PageObjectDependencyInjector(new Pages(driver));
            injector.injectDependenciesInto((Object)performAction.getPerformable());
        }
    }

    @Subscribe
    public void prepareQuestion(ActorAsksQuestion questionEvent) {
        if (this.messageIsForThisActor((ActorPerformanceEvent)questionEvent)) {
            WebDriver driver = this.webdriverManager.getWebdriver();
            PageObjectDependencyInjector injector = new PageObjectDependencyInjector(new Pages(driver));
            injector.injectDependenciesInto((Object)questionEvent.getQuestion());
        }
    }

    @Subscribe
    public void beginPerformance(ActorBeginsPerformanceEvent performanceEvent) {
        if (this.messageIsForThisActor((ActorPerformanceEvent)performanceEvent)) {
            SerenityWebdriverManager.inThisTestThread().setCurrentActiveDriver(this.getDriver());
        }
    }

    @Subscribe
    public void endPerformance(ActorEndsPerformanceEvent performanceEvent) {
        if (this.messageIsForThisActor((ActorPerformanceEvent)performanceEvent)) {
            SerenityWebdriverManager.inThisTestThread().clearCurrentActiveDriver();
        }
    }

    private boolean messageIsForThisActor(ActorPerformanceEvent event) {
        return event.getName().equals(this.actor.getName());
    }

    public <T extends Ability> T asActor(Actor actor) {
        this.actor = actor;
        return (T)((Object)this);
    }

    public String toString() {
        return "browse the web";
    }
}

