/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.matchers;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.thucydides.core.annotations.Fields;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class ConsequenceMatchers {
    public static <T> Matcher<T> displays(String propertyName, Matcher<?> valueMatcher) {
        return new AnswerMatcher(propertyName, valueMatcher);
    }

    public static class AnswerMatcher<T>
    extends TypeSafeMatcher<T> {
        private final String propertyName;
        private final Matcher<?> valueMatcher;

        protected void describeMismatchSafely(T domainObject, Description mismatchDescription) {
            mismatchDescription.appendText("displayed  '").appendText(this.propertyName).appendText("' as ").appendValue(this.fieldsOf(domainObject).get(this.propertyName));
        }

        public AnswerMatcher(String propertyName, Matcher<?> valueMatcher) {
            this.propertyName = propertyName;
            this.valueMatcher = valueMatcher;
        }

        protected boolean matchesSafely(T domainObject) {
            Preconditions.checkState((boolean)this.fieldsOf(domainObject).containsKey(this.propertyName), (Object)("Unknown display field '" + this.propertyName + "'. Must be one of: " + this.nonStaticFieldsOf(domainObject)));
            return this.valueMatcher.matches(this.fieldsOf(domainObject).get(this.propertyName));
        }

        private Map<String, Object> fieldsOf(T domainObject) {
            return Fields.of(domainObject).asMap();
        }

        private String nonStaticFieldsOf(T domainObject) {
            ArrayList<String> fieldNames = new ArrayList<String>();
            Set fields = Fields.of(domainObject.getClass()).nonStaticFields();
            for (Field field : fields) {
                fieldNames.add("'" + field.getName() + "'");
            }
            return StringUtils.join(fieldNames, (String)", ");
        }

        public void describeTo(Description description) {
            description.appendText("to display '").appendText(this.propertyName).appendText("' as ");
            this.valueMatcher.describeTo(description);
        }
    }
}

