/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.serenitybdd.reports.model.DurationDistribution;
import net.thucydides.core.model.OutcomeCounter;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.DurationReportingTask;
import net.thucydides.core.reports.html.FreemarkerContext;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.reports.html.ReportingTask;
import net.thucydides.core.reports.html.ResultReportingTask;
import net.thucydides.core.reports.html.TagExclusions;
import net.thucydides.core.util.EnvironmentVariables;

public class ResultReports {
    public static List<ReportingTask> resultReportsFor(TestOutcomes testOutcomes, FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, ReportNameProvider reportNameProvider) {
        ArrayList<ReportingTask> reportingTasks = new ArrayList<ReportingTask>();
        reportingTasks.addAll(ResultReports.resultReportsFor(freemarker, environmentVariables, outputDirectory, testOutcomes, reportNameProvider, TestTag.EMPTY_TAG));
        reportingTasks.addAll(ResultReports.durationReportsFor(freemarker, environmentVariables, outputDirectory, testOutcomes, reportNameProvider, TestTag.EMPTY_TAG));
        TagExclusions exclusions = TagExclusions.usingEnvironment((EnvironmentVariables)environmentVariables);
        reportingTasks.addAll(testOutcomes.getTags().stream().filter(arg_0 -> ((TagExclusions)exclusions).doNotExclude(arg_0)).flatMap(tag -> ResultReports.resultReportsFor(freemarker, environmentVariables, outputDirectory, testOutcomes.withTag(tag), new ReportNameProvider(tag.getName()), tag).stream()).collect(Collectors.toList()));
        reportingTasks.addAll(testOutcomes.getTags().stream().filter(arg_0 -> ((TagExclusions)exclusions).doNotExclude(arg_0)).flatMap(tag -> ResultReports.durationReportsFor(freemarker, environmentVariables, outputDirectory, testOutcomes.withTag(tag), new ReportNameProvider(tag.getName()), tag).stream()).collect(Collectors.toList()));
        return reportingTasks;
    }

    private static List<ReportingTask> resultReportsFor(FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, TestOutcomes testOutcomesForThisTag, ReportNameProvider reportName, TestTag tag) {
        ArrayList<ReportingTask> tasks = new ArrayList<ReportingTask>();
        OutcomeCounter totalTests = testOutcomesForThisTag.getTotalTests();
        if (totalTests.withResult(TestResult.SUCCESS) > 0) {
            tasks.add(ResultReports.resultReport(freemarker, environmentVariables, outputDirectory, testOutcomesForThisTag.getPassingTests(), reportName, tag, "success"));
        }
        if (totalTests.withResult(TestResult.PENDING) > 0) {
            tasks.add(ResultReports.resultReport(freemarker, environmentVariables, outputDirectory, testOutcomesForThisTag.getPendingTests(), reportName, tag, "pending"));
        }
        if (totalTests.withResult(TestResult.FAILURE) > 0 || totalTests.withResult(TestResult.ERROR) > 0) {
            tasks.add(ResultReports.resultReport(freemarker, environmentVariables, outputDirectory, testOutcomesForThisTag.getUnsuccessfulTests(), reportName, tag, "broken"));
        }
        if (totalTests.withResult(TestResult.FAILURE) > 0) {
            tasks.add(ResultReports.resultReport(freemarker, environmentVariables, outputDirectory, testOutcomesForThisTag.getFailingTests(), reportName, tag, "failure"));
        }
        if (totalTests.withResult(TestResult.ABORTED) > 0) {
            tasks.add(ResultReports.resultReport(freemarker, environmentVariables, outputDirectory, testOutcomesForThisTag.getAbortedTests(), reportName, tag, "aborted"));
        }
        if (totalTests.withResult(TestResult.ERROR) > 0) {
            tasks.add(ResultReports.resultReport(freemarker, environmentVariables, outputDirectory, testOutcomesForThisTag.getErrorTests(), reportName, tag, "error"));
        }
        if (totalTests.withResult(TestResult.COMPROMISED) > 0) {
            tasks.add(ResultReports.resultReport(freemarker, environmentVariables, outputDirectory, testOutcomesForThisTag.getCompromisedTests(), reportName, tag, "compromised"));
        }
        if (totalTests.withResult(TestResult.IGNORED) > 0) {
            tasks.add(ResultReports.resultReport(freemarker, environmentVariables, outputDirectory, testOutcomesForThisTag.havingResult(TestResult.IGNORED), reportName, tag, "ignored"));
        }
        if (totalTests.withResult(TestResult.SKIPPED) > 0) {
            tasks.add(ResultReports.resultReport(freemarker, environmentVariables, outputDirectory, testOutcomesForThisTag.havingResult(TestResult.SKIPPED), reportName, tag, "skipped"));
        }
        return tasks;
    }

    private static List<ReportingTask> durationReportsFor(FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, TestOutcomes testOutcomesForThisTag, ReportNameProvider reportName, TestTag currentTag) {
        ArrayList<ReportingTask> tasks = new ArrayList<ReportingTask>();
        DurationDistribution durationDistribution = new DurationDistribution(environmentVariables, testOutcomesForThisTag);
        durationDistribution.getDurationBuckets().forEach(bucket -> {
            if (!bucket.getOutcomes().isEmpty()) {
                String label = "Duration " + bucket.getDuration();
                if (!currentTag.getCompleteName().isEmpty()) {
                    label = currentTag.getName() + " > " + label;
                }
                tasks.add(ResultReports.durationReport(freemarker, environmentVariables, outputDirectory, TestOutcomes.of((Collection)bucket.getOutcomes()).withLabel(label), reportName, currentTag, bucket.getDuration()));
            }
        });
        return tasks;
    }

    private static ReportingTask resultReport(FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, TestOutcomes testOutcomes, ReportNameProvider reportName, TestTag tag, String testResult) {
        return new ResultReportingTask(freemarker, environmentVariables, outputDirectory, testOutcomes, reportName, tag, testResult);
    }

    private static ReportingTask durationReport(FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, TestOutcomes testOutcomes, ReportNameProvider reportName, TestTag tag, String testResult) {
        return new DurationReportingTask(freemarker, environmentVariables, outputDirectory, testOutcomes, reportName, tag, testResult);
    }
}

