/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import net.serenitybdd.core.time.Stopwatch;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.BaseReportingTask;
import net.thucydides.core.reports.html.FreemarkerContext;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.reports.html.ReportingTask;
import net.thucydides.core.util.EnvironmentVariables;

public class TextSummaryReportTask
extends BaseReportingTask
implements ReportingTask {
    private static final String TEST_SUMMARY_TEMPLATE_PATH = "freemarker/text-summary.ftl";
    private static final String TEST_SUMMARY_REPORT_NAME = "summary.txt";
    protected final ReportNameProvider reportNameProvider;
    private final TestOutcomes testOutcomes;

    public TextSummaryReportTask(FreemarkerContext context, EnvironmentVariables environmentVariables, File outputDirectory, TestOutcomes testOutcomes) {
        super(context, environmentVariables, outputDirectory);
        this.testOutcomes = testOutcomes;
        this.reportNameProvider = new ReportNameProvider(ReportNameProvider.NO_CONTEXT, ReportType.HTML);
    }

    @Override
    public void generateReports() throws IOException {
        Map<String, Object> context = this.freemarker.getBuildContext(this.testOutcomes, this.reportNameProvider, true);
        Stopwatch stopwatch = Stopwatch.started();
        this.generateReportPage(context, TEST_SUMMARY_TEMPLATE_PATH, TEST_SUMMARY_REPORT_NAME);
        LOGGER.trace("Summary report generated: {} ms", (Object)stopwatch.stop());
    }

    public String toString() {
        return "Test Summary Report";
    }
}

