/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports;

import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.OutcomeCounter;
import net.thucydides.core.model.Release;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestType;
import net.thucydides.core.releases.ReleaseManager;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.reports.html.RequirementsFilter;
import net.thucydides.core.requirements.ExcludedUnrelatedRequirementTypes;
import net.thucydides.core.requirements.RequirementsTagProvider;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.requirements.reports.RequirementOutcome;
import net.thucydides.core.requirements.reports.RequirementsOutcomesOfTypeCache;
import net.thucydides.core.requirements.reports.RequirementsPercentageFormatter;
import net.thucydides.core.requirements.reports.RequirementsProportionCounter;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class RequirementsOutcomes {
    private final List<RequirementOutcome> requirementOutcomes;
    private final TestOutcomes testOutcomes;
    private final Optional<Requirement> parentRequirement;
    private final EnvironmentVariables environmentVariables;
    private final IssueTracking issueTracking;
    private final List<? extends RequirementsTagProvider> requirementsTagProviders;
    private final ReleaseManager releaseManager;
    private final ReportNameProvider reportNameProvider;
    List<RequirementOutcome> flattenedRequirementOutcomes = null;
    List<RequirementOutcome> leafRequirementOutcomes = null;
    private final String overview;
    public static final Integer DEFAULT_TESTS_PER_REQUIREMENT = 4;
    private final Map<String, Integer> totalCountCache = new ConcurrentHashMap<String, Integer>();
    RequirementsOutcomesOfTypeCache requirementsOfTypeCache = new RequirementsOutcomesOfTypeCache(this);

    public RequirementsOutcomes(List<Requirement> requirements, TestOutcomes testOutcomes, IssueTracking issueTracking, EnvironmentVariables environmentVariables, List<? extends RequirementsTagProvider> requirementsTagProviders, ReportNameProvider reportNameProvider, String overview) {
        this(null, requirements, testOutcomes, issueTracking, environmentVariables, requirementsTagProviders, reportNameProvider, overview);
    }

    public RequirementsOutcomes(Requirement parentRequirement, List<Requirement> requirements, TestOutcomes testOutcomes, IssueTracking issueTracking, EnvironmentVariables environmentVariables, List<? extends RequirementsTagProvider> requirementsTagProviders, ReportNameProvider reportNameProvider, String overview) {
        this.testOutcomes = testOutcomes;
        this.parentRequirement = Optional.ofNullable(parentRequirement);
        this.environmentVariables = environmentVariables;
        this.issueTracking = issueTracking;
        this.requirementsTagProviders = requirementsTagProviders;
        this.requirementOutcomes = this.buildRequirementOutcomes(requirements);
        this.reportNameProvider = reportNameProvider;
        this.releaseManager = new ReleaseManager(environmentVariables, reportNameProvider);
        this.overview = overview;
    }

    RequirementsOutcomes(ReportNameProvider reportNameProvider, List<RequirementOutcome> requirementOutcomes, TestOutcomes testOutcomes, Optional<Requirement> parentRequirement, EnvironmentVariables environmentVariables, IssueTracking issueTracking, List<? extends RequirementsTagProvider> requirementsTagProviders, ReleaseManager releaseManager, String overview) {
        this.reportNameProvider = reportNameProvider;
        this.requirementOutcomes = requirementOutcomes;
        this.testOutcomes = testOutcomes;
        this.parentRequirement = parentRequirement;
        this.environmentVariables = environmentVariables;
        this.issueTracking = issueTracking;
        this.requirementsTagProviders = requirementsTagProviders;
        this.releaseManager = releaseManager;
        this.overview = overview;
    }

    private List<RequirementOutcome> buildRequirementOutcomes(List<Requirement> requirements) {
        return requirements.stream().distinct().map(this::requirementOutcomeFor).collect(Collectors.toList());
    }

    public RequirementOutcome requirementOutcomeFor(Requirement requirement) {
        TestOutcomes outcomesForRequirement = this.testOutcomes.forRequirement(requirement);
        long requirementsWithoutTests = this.countRequirementsWithoutTestsIn(requirement);
        long estimatedUnimplementedTests = requirementsWithoutTests * (long)this.estimatedTestsPerRequirement();
        return new RequirementOutcome(requirement, outcomesForRequirement, requirementsWithoutTests, estimatedUnimplementedTests, this.issueTracking);
    }

    public long getTestCaseCount() {
        return this.testOutcomes.getTestCaseCount();
    }

    public long getScenarioCount() {
        return this.testOutcomes.getScenarioCount();
    }

    public List<Requirement> getRequirements() {
        return this.requirementOutcomes.stream().map(RequirementOutcome::getRequirement).collect(Collectors.toList());
    }

    public RequirementsOutcomes requirementsOfType(String type) {
        return this.requirementsOfTypeCache.byType(type);
    }

    public RequirementsOutcomes ofType(String type) {
        ArrayList<Requirement> matchingRequirements = new ArrayList<Requirement>();
        ArrayList<? extends TestOutcome> matchingTests = new ArrayList<TestOutcome>();
        for (RequirementOutcome requirementOutcome : this.getFlattenedRequirementOutcomes()) {
            if (!requirementOutcome.getRequirement().getType().equalsIgnoreCase(type)) continue;
            matchingRequirements.add(requirementOutcome.getRequirement());
            matchingTests.addAll(requirementOutcome.getTestOutcomes().getOutcomes());
        }
        return new RequirementsOutcomes(matchingRequirements, TestOutcomes.of(matchingTests), this.issueTracking, this.environmentVariables, this.requirementsTagProviders, this.reportNameProvider, this.overview).withoutUnrelatedRequirements();
    }

    private long countRequirementsWithoutTestsIn(Requirement rootRequirement) {
        return this.getFlattenedRequirements(rootRequirement).stream().filter(requirement -> this.testOutcomes.forRequirement((Requirement)requirement).getTotal() == 0).count();
    }

    public int getFlattenedRequirementCount() {
        if (this.totalIsCachedFor("FlattenedRequirementCount")) {
            return this.cachedTotalOf("FlattenedRequirementCount");
        }
        int requirementCount = this.requirementOutcomes.stream().mapToInt(RequirementOutcome::getFlattenedRequirementCount).sum();
        return this.cachedTotal("FlattenedRequirementCount", requirementCount);
    }

    private int cachedTotal(String key, int total) {
        this.totalCountCache.put(key, total);
        return total;
    }

    private int cachedTotalOf(String key) {
        return this.totalCountCache.get(key);
    }

    private boolean totalIsCachedFor(String key) {
        return this.totalCountCache.containsKey(key);
    }

    private List<Requirement> getFlattenedRequirements(Requirement rootRequirement) {
        ArrayList<Requirement> flattenedRequirements = new ArrayList<Requirement>();
        flattenedRequirements.add(rootRequirement);
        flattenedRequirements.addAll(rootRequirement.getNestedChildren());
        return flattenedRequirements;
    }

    public Optional<Requirement> getParentRequirement() {
        return this.parentRequirement;
    }

    public Optional<Requirement> getGrandparentRequirement() {
        if (!this.parentRequirement.isPresent()) {
            return Optional.empty();
        }
        if (StringUtils.isEmpty((CharSequence)this.parentRequirement.get().getParent())) {
            return Optional.empty();
        }
        return this.parentRequirementOf(this.parentRequirement.get());
    }

    private Optional<Requirement> parentRequirementOf(Requirement requirement) {
        for (RequirementsTagProvider requirementsTagProvider : this.requirementsTagProviders) {
            if (!requirementsTagProvider.getParentRequirementOf(requirement).isPresent()) continue;
            return requirementsTagProvider.getParentRequirementOf(requirement);
        }
        return Optional.empty();
    }

    public int getRequirementCount() {
        return this.requirementOutcomes.size();
    }

    public List<RequirementOutcome> getRequirementOutcomes() {
        return this.requirementOutcomes;
    }

    public List<RequirementOutcome> getVisibleOutcomes() {
        return this.requirementOutcomes.stream().filter(outcome -> this.includeEmptyRequirements() || !outcome.getTestOutcomes().isEmpty()).collect(Collectors.toList());
    }

    private boolean includeEmptyRequirements() {
        return !EnvironmentSpecificConfiguration.from(this.environmentVariables).getBooleanProperty(ThucydidesSystemProperty.SERENITY_REPORT_HIDE_EMPTY_REQUIREMENTS, true);
    }

    public String getType() {
        if (this.requirementOutcomes.isEmpty()) {
            return "requirement";
        }
        return this.requirementOutcomes.get(0).getRequirement().getType();
    }

    public String getChildrenType() {
        return this.typeOfFirstChildPresent();
    }

    public List<String> getTypes() {
        return this.getAllRequirementsStream().map(Requirement::getType).distinct().collect(Collectors.toList());
    }

    private String typeOfFirstChildPresent() {
        for (RequirementOutcome outcome : this.requirementOutcomes) {
            if (outcome.getRequirement().getChildren().isEmpty()) continue;
            Requirement firstChildRequirement = outcome.getRequirement().getChildren().get(0);
            return firstChildRequirement.getType();
        }
        return null;
    }

    public TestOutcomes getTestOutcomes() {
        return this.testOutcomes;
    }

    public Optional<TestResult> getTestResultForTestNamed(String name) {
        Optional<? extends TestOutcome> testOutcome = this.testOutcomes.testOutcomeWithName(name);
        return testOutcome.map(TestOutcome::getResult);
    }

    public String toString() {
        return "RequirementsOutcomes{requirementOutcomes=" + this.requirementOutcomes + ", parentRequirement=" + this.parentRequirement + '}';
    }

    public int getCompletedRequirementsCount() {
        if (this.totalIsCachedFor("CompletedRequirementsCount")) {
            return this.cachedTotalOf("CompletedRequirementsCount");
        }
        int completedRequirements = 0;
        for (RequirementOutcome requirementOutcome : this.requirementOutcomes) {
            if (!requirementOutcome.isComplete()) continue;
            ++completedRequirements;
        }
        return this.cachedTotal("CompletedRequirementsCount", completedRequirements);
    }

    public int getUnsuccessfulRequirementsCount() {
        return this.getErrorRequirementsCount() + this.getFailingRequirementsCount() + this.getCompromisedRequirementsCount();
    }

    public int getErrorRequirementsCount() {
        if (this.totalIsCachedFor("ErrorRequirementsCount")) {
            return this.cachedTotalOf("ErrorRequirementsCount");
        }
        int matchingRequirements = (int)this.requirementOutcomes.stream().filter(RequirementOutcome::isError).count();
        return this.cachedTotal("ErrorRequirementsCount", matchingRequirements);
    }

    public int getFailingRequirementsCount() {
        if (this.totalIsCachedFor("FailingRequirementsCount")) {
            return this.cachedTotalOf("FailingRequirementsCount");
        }
        int matchingRequirements = (int)this.requirementOutcomes.stream().filter(RequirementOutcome::isFailure).count();
        return this.cachedTotal("FailingRequirementsCount", matchingRequirements);
    }

    public int getPendingRequirementsCount() {
        if (this.totalIsCachedFor("PendingRequirementsCount")) {
            return this.cachedTotalOf("PendingRequirementsCount");
        }
        int matchingRequirements = (int)this.requirementOutcomes.stream().filter(RequirementOutcome::isPending).count();
        return this.cachedTotal("PendingRequirementsCount", matchingRequirements);
    }

    public int getCompromisedRequirementsCount() {
        if (this.totalIsCachedFor("CompromisedRequirementsCount")) {
            return this.cachedTotalOf("CompromisedRequirementsCount");
        }
        int matchingRequirements = (int)this.requirementOutcomes.stream().filter(RequirementOutcome::isCompromised).count();
        return this.cachedTotal("CompromisedRequirementsCount", matchingRequirements);
    }

    public int getIgnoredRequirementsCount() {
        if (this.totalIsCachedFor("IgnoredRequirementsCount")) {
            return this.cachedTotalOf("IgnoredRequirementsCount");
        }
        int matchingRequirements = (int)this.requirementOutcomes.stream().filter(RequirementOutcome::isIgnored).count();
        return this.cachedTotal("IgnoredRequirementsCount", matchingRequirements);
    }

    public int getSkippedRequirementsCount() {
        if (this.totalIsCachedFor("SkippedRequirementsCount")) {
            return this.cachedTotalOf("SkippedRequirementsCount");
        }
        int matchingRequirements = (int)this.requirementOutcomes.stream().filter(RequirementOutcome::isSkipped).count();
        return this.cachedTotal("SkippedRequirementsCount", matchingRequirements);
    }

    public int getRequirementsWithoutTestsCount() {
        if (this.totalIsCachedFor("RequirementsWithoutTestsCount")) {
            return this.cachedTotalOf("RequirementsWithoutTestsCount");
        }
        int requirementsWithNoTests = 0;
        for (Requirement requirement : this.getTopLevelRequirements()) {
            if (this.testsRecordedFor(requirement) || this.isPending(requirement)) continue;
            ++requirementsWithNoTests;
        }
        return this.cachedTotal("IgnoredRequirementsCount", requirementsWithNoTests);
    }

    private boolean isPending(Requirement requirement) {
        return this.requirementOutcomes.stream().anyMatch(req -> req.getRequirement().equals(requirement) && req.isPending());
    }

    private boolean testsRecordedFor(Requirement requirement) {
        return this.requirementOutcomes.stream().anyMatch(req -> req.getRequirement().equals(requirement) && req.getTestCount() > 0L);
    }

    private Stream<Requirement> getAllRequirementsStream() {
        return this.requirementOutcomes.stream().flatMap(outcome -> this.flattenedRequirementsOf(outcome.getRequirement()));
    }

    private List<Requirement> getTopLevelRequirements() {
        return this.requirementOutcomes.stream().map(RequirementOutcome::getRequirement).collect(Collectors.toList());
    }

    public long getTotalRequirements() {
        return this.getAllRequirementsStream().count();
    }

    private Stream<Requirement> flattenedRequirementsOf(Requirement requirement) {
        return Streams.concat((Stream[])new Stream[]{Stream.of(requirement), requirement.getChildren().stream().flatMap(this::flattenedRequirementsOf)});
    }

    private void addFlattenedRequirements(Requirement requirement, List<Requirement> allRequirements) {
        allRequirements.add(requirement);
        for (Requirement child : requirement.getChildren()) {
            this.addFlattenedRequirements(child, allRequirements);
        }
    }

    public List<RequirementOutcome> getFlattenedRequirementOutcomes() {
        if (this.flattenedRequirementOutcomes == null) {
            this.flattenedRequirementOutcomes = this.getFlattenedRequirementOutcomes(this.requirementOutcomes);
        }
        return this.flattenedRequirementOutcomes;
    }

    public List<RequirementOutcome> getLeafRequirementOutcomes() {
        if (this.leafRequirementOutcomes == null) {
            this.leafRequirementOutcomes = this.getLeafRequirementOutcomes(this.getFlattenedRequirementOutcomes(this.requirementOutcomes));
        }
        return this.leafRequirementOutcomes;
    }

    public List<RequirementOutcome> getLeafRequirementOutcomes(List<RequirementOutcome> outcomes) {
        return outcomes.stream().filter(outcome -> !outcome.getRequirement().hasChildren()).collect(Collectors.toList());
    }

    public List<RequirementOutcome> getFlattenedRequirementOutcomes(List<RequirementOutcome> outcomes) {
        ArrayList<Requirement> allRequirements = new ArrayList<Requirement>();
        for (RequirementOutcome outcome : outcomes) {
            this.addFlattenedRequirements(outcome.getRequirement(), allRequirements);
        }
        ArrayList<RequirementOutcome> flattenedOutcomes = new ArrayList<RequirementOutcome>();
        for (Requirement requirement : allRequirements) {
            RequirementOutcome requirementOutcome = this.getRequirementOutcomes(requirement);
            flattenedOutcomes.add(requirementOutcome);
        }
        return flattenedOutcomes;
    }

    public List<RequirementOutcome> getFlattenedRequirementOutcomesOld(List<RequirementOutcome> outcomes) {
        ArrayList<RequirementOutcome> flattenedOutcomes = new ArrayList<RequirementOutcome>();
        for (RequirementOutcome outcome : outcomes) {
            flattenedOutcomes.add(outcome);
            flattenedOutcomes.addAll(this.getFlattenedRequirementOutcomes(outcome.getRequirement().getChildren(), outcome));
        }
        return flattenedOutcomes;
    }

    RequirementOutcome getRequirementOutcomes(Requirement requirement) {
        TestOutcomes testOutcomesForRequirement = this.testOutcomes.forRequirement(requirement);
        return new RequirementOutcome(requirement, testOutcomesForRequirement, this.issueTracking);
    }

    private RequirementOutcome getRequirementOutcomes(Requirement requirement, RequirementOutcome requirementOutcome) {
        TestOutcomes testOutcomesForChildRequirement = requirementOutcome.getTestOutcomes().forRequirement(requirement);
        RequirementsOutcomes childOutcomes = new RequirementsOutcomes(Collections.singletonList(requirement), testOutcomesForChildRequirement, this.issueTracking, this.environmentVariables, this.requirementsTagProviders, this.reportNameProvider, this.overview).withoutUnrelatedRequirements();
        return childOutcomes.getRequirementOutcomes().get(0);
    }

    private List<RequirementOutcome> getFlattenedRequirementOutcomes(List<Requirement> requirements, RequirementOutcome requirementOutcome) {
        ArrayList<RequirementOutcome> flattenedOutcomes = new ArrayList<RequirementOutcome>();
        for (Requirement childRequirement : requirements) {
            TestOutcomes testOutcomesForChildRequirement = requirementOutcome.getTestOutcomes().forRequirement(childRequirement);
            RequirementsOutcomes childOutcomes = new RequirementsOutcomes(Collections.singletonList(childRequirement), testOutcomesForChildRequirement, this.issueTracking, this.environmentVariables, this.requirementsTagProviders, this.reportNameProvider, this.overview).withoutUnrelatedRequirements();
            flattenedOutcomes.addAll(childOutcomes.getRequirementOutcomes());
        }
        return flattenedOutcomes;
    }

    public OutcomeCounter getTotal() {
        return this.count(TestType.ANY);
    }

    public OutcomeCounter count(TestType testType) {
        return new OutcomeCounter(testType, this.getTestOutcomes());
    }

    public OutcomeCounter count(String testType) {
        return this.count(TestType.valueOf(testType.toUpperCase()));
    }

    public int getTotalTestCount() {
        return this.testOutcomes.getTotal();
    }

    public RequirementsPercentageFormatter getFormattedPercentage() {
        return new RequirementsPercentageFormatter(this.getProportion());
    }

    public RequirementsPercentageFormatter getFormattedPercentage(String testType) {
        return new RequirementsPercentageFormatter(this.proportionOf(testType));
    }

    public RequirementsPercentageFormatter getFormattedPercentage(TestType testType) {
        return new RequirementsPercentageFormatter(this.proportionOf(testType));
    }

    private int totalEstimatedAndImplementedTests() {
        int totalImplementedTests = this.getTotalTestCount();
        return totalImplementedTests + this.getEstimatedUnimplementedTests();
    }

    public int getEstimatedUnimplementedTests() {
        return this.getRequirementsWithoutTestsCount() * this.estimatedTestsPerRequirement();
    }

    private int estimatedTestsPerRequirement() {
        return ThucydidesSystemProperty.SERENITY_ESTIMATED_TESTS_PER_REQUIREMENT.integerFrom(this.environmentVariables, DEFAULT_TESTS_PER_REQUIREMENT);
    }

    public RequirementsProportionCounter getProportion() {
        return this.proportionOf(TestType.ANY);
    }

    public RequirementsProportionCounter proportionOf(String testType) {
        return this.proportionOf(TestType.valueOf(testType.toUpperCase()));
    }

    public RequirementsProportionCounter proportionOf(TestType testType) {
        return new RequirementsProportionCounter(testType, this.testOutcomes, this.totalEstimatedAndImplementedTests());
    }

    public RequirementsOutcomes getReleasedRequirementsFor(Release release) {
        Set<Requirement> matchingRequirements = new HashSet<Requirement>();
        HashSet<TestOutcome> matchingTestOutcomes = new HashSet<TestOutcome>();
        List<RequirementOutcome> requirementOutcomes = this.releaseManager.enrichRequirementsOutcomesWithReleaseTags(this.getRequirementOutcomes());
        for (RequirementOutcome outcome : requirementOutcomes) {
            List<TestOutcome> outcomesForRelease;
            Set<String> releaseVersions = outcome.getReleaseVersions();
            if (!releaseVersions.contains(release.getName()) || (outcomesForRelease = this.outcomesForRelease(outcome.getTestOutcomes().getOutcomes(), release.getName())).isEmpty()) continue;
            matchingTestOutcomes.addAll(outcomesForRelease);
            matchingRequirements.add(outcome.getRequirement());
        }
        matchingRequirements = this.removeRequirementsWithoutTestsFrom(matchingRequirements);
        return new RequirementsOutcomes(new ArrayList<Requirement>(matchingRequirements), TestOutcomes.of(matchingTestOutcomes), this.issueTracking, this.environmentVariables, this.requirementsTagProviders, this.reportNameProvider, this.overview).withoutUnrelatedRequirements();
    }

    private Set<Requirement> removeRequirementsWithoutTestsFrom(Collection<Requirement> requirements) {
        HashSet<Requirement> prunedRequirements = new HashSet<Requirement>();
        for (Requirement requirement : requirements) {
            if (!this.testsExistFor(requirement)) continue;
            Set<Requirement> prunedChildren = this.removeRequirementsWithoutTestsFrom(requirement.getChildren());
            prunedRequirements.add(requirement.withChildren(new ArrayList<Requirement>(prunedChildren)));
        }
        return prunedRequirements;
    }

    private boolean testsExistFor(Requirement requirement) {
        return !this.getTestOutcomes().forRequirement(requirement).getOutcomes().isEmpty();
    }

    private List<TestOutcome> outcomesForRelease(List<? extends TestOutcome> outcomes, String releaseName) {
        this.releaseManager.enrichOutcomesWithReleaseTags(outcomes);
        return outcomes.stream().filter(outcome -> outcome.getVersions().contains(releaseName)).collect(Collectors.toList());
    }

    public RequirementsOutcomes filteredByDisplayTag() {
        return new RequirementsOutcomes(this.reportNameProvider, this.filteredByDisplayTag(this.requirementOutcomes), this.testOutcomes, this.parentRequirement, this.environmentVariables, this.issueTracking, this.requirementsTagProviders, this.releaseManager, this.overview);
    }

    public RequirementsOutcomes withoutUnrelatedRequirements() {
        if (ThucydidesSystemProperty.SERENITY_EXCLUDE_UNRELATED_REQUIREMENTS_OF_TYPE.from(this.environmentVariables, "none").equalsIgnoreCase("none")) {
            return this;
        }
        return new RequirementsOutcomes(this.reportNameProvider, this.pruned(this.requirementOutcomes), this.testOutcomes, this.parentRequirement, this.environmentVariables, this.issueTracking, this.requirementsTagProviders, this.releaseManager, this.overview);
    }

    private List<RequirementOutcome> pruned(List<RequirementOutcome> requirementOutcomes) {
        return requirementOutcomes.stream().filter(requirementOutcome -> !this.shouldPrune((RequirementOutcome)requirementOutcome)).map(RequirementOutcome::withoutUnrelatedRequirements).distinct().collect(Collectors.toList());
    }

    private List<RequirementOutcome> filteredByDisplayTag(List<RequirementOutcome> requirementOutcomes) {
        return requirementOutcomes.stream().filter(this::shouldDisplay).map(requirementOutcome -> requirementOutcome.filteredByDisplayTag()).distinct().collect(Collectors.toList());
    }

    public boolean shouldPrune(RequirementOutcome requirementOutcome) {
        return requirementOutcome.getTestCount() == 0L && ExcludedUnrelatedRequirementTypes.definedIn(this.environmentVariables).excludeUntestedRequirementOfType(requirementOutcome.getRequirement().getType());
    }

    private boolean shouldDisplay(RequirementOutcome requirementOutcome) {
        RequirementsFilter requirementsFilter = new RequirementsFilter(this.environmentVariables);
        return requirementsFilter.inDisplayOnlyTags(requirementOutcome.getRequirement());
    }

    public String getOverview() {
        return this.overview;
    }

    public Optional<RequirementOutcome> getOutcomeFor(Requirement requirement) {
        return this.requirementOutcomes.stream().filter(requirementOutcome -> requirementOutcome.getRequirement().equals(requirement)).findFirst();
    }
}

