/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import java.lang.reflect.Method;
import java.util.Arrays;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestClassHierarchy;
import net.thucydides.core.requirements.PackageRequirementsTagProvider;
import net.thucydides.core.requirements.RequirementTypesProvider;
import net.thucydides.core.requirements.classpath.PathElements;
import net.thucydides.core.requirements.model.FeatureType;
import net.thucydides.core.util.EnvironmentVariables;

public class PackageBasedLeafRequirements {
    private final RequirementTypesProvider requirementTypesProvider;
    private final String rootPackage;

    public PackageBasedLeafRequirements(EnvironmentVariables environmentVariables) {
        this.rootPackage = ThucydidesSystemProperty.SERENITY_TEST_ROOT.from(environmentVariables);
        this.requirementTypesProvider = new PackageRequirementsTagProvider(environmentVariables, this.rootPackage);
    }

    public Story testCase(Class<?> testCase) {
        String storyName = TestClassHierarchy.getInstance().displayNameFor(testCase.getName()).orElse(testCase.getSimpleName());
        Story story = Story.testedInTestCase(testCase) != null ? Story.from(Story.testedInTestCase(testCase)).withType(this.typeFrom(testCase.getName())) : (this.containsJUnitTestCases(testCase) ? Story.from(testCase).withType(FeatureType.FEATURE.toString()).withStoryName(storyName).withDisplayName(storyName) : Story.from(testCase).withType(this.typeFrom(testCase.getName())).withStoryName(storyName).withDisplayName(storyName));
        return story;
    }

    private boolean containsJUnitTestCases(Class<?> testCase) {
        Method[] declaredMethods;
        for (Method method : declaredMethods = testCase.getDeclaredMethods()) {
            if (!Arrays.stream(method.getAnnotations()).anyMatch(annotation -> annotation.annotationType().getName().endsWith(".Test"))) continue;
            return true;
        }
        return false;
    }

    public Story story(Story userStory) {
        return userStory;
    }

    private String typeFrom(String path) {
        path = path.replaceAll("\\$", ".");
        if (this.rootPackage == null || this.requirementTypesProvider.getActiveRequirementTypes().isEmpty()) {
            return FeatureType.FEATURE.toString();
        }
        int requirementsLevel = PathElements.elementsOf(path, this.rootPackage).size() - 1;
        int effectiveRequirementsLevel = Math.min(requirementsLevel, this.requirementTypesProvider.getActiveRequirementTypes().size() - 1);
        return this.requirementTypesProvider.getActiveRequirementTypes().get(effectiveRequirementsLevel);
    }
}

